﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class TutorialLevel1Manager : LevelManager
{
    // Start is called before the first frame update
    Vector3 orig;
    public GameObject target1;
    public GameObject target2;
    public GameObject target3;
    bool isCond1;
    bool isCond2;
    bool isCond3;

    protected override void Start()
    {
        ExplanationText = new string[]{"어서오게 영웅이여!",
            "난 빛의 수호자 우서라고 하네.",
            "자넨 민코프스키 시공간 폭풍에게 선택을 받았네!",
            "뭐, 히오스? 엇, 그, 그런건 모르겠고, 일단 좀 들어보게나.",
            "시공간 폭풍은 시간과 공간을 초월해 공간의 차원 2개와 시간의 차원 1개가 엮여있는 기하일세.",
            "세계와 세계가 부딫히는 거대한 우주 폭풍이지.",
            "자네가 여기 소환된건, 수많은 퍼즐을 통해 자신을 시험하고, 큰 영광을 이루기 위함이네!",
            "음....왜 퍼즐을 푸냐고? 그러니까, 이런 일은 말일세.. 그렇게 머리 싸매고 생각할 필요가 없다네.",
            "그럴 시간에 퍼즐이나 하나 더 푸게나.",
            "일단 시공간 폭풍의 퍼즐을 풀기 위한 기본적 규칙들 설명해주겠네",
            "시공간 폭풍은 아인슈타인이 정립한 특수상대론의 규칙들을 따른다네",
            "자세히 알필욘 없고, 중요한건 두가지네.",
            "먼저 그 어떠한 것도 절대로 빛의 속도보다 빠르게 갈수는 없다네.",
            "빛의 속도보다 빨리 이동하는 것처럼 착시가 일어날 수는 있지만, (계속)",
            "실제로 네가 보기에 빛보다 빨리 움직이는 것은 없다네.",
            "화면에 초록색의 동그라미들과 숫자들이 보일텐데 (계속)",
            "이때 각 동그라미는 자네로부터 1광초 - 즉 빛이 가는데 1초가 걸리는 거리 만큼 마다 그려져있네.",
            "이걸로 목표까지 거리를 예측할수 있다네.",
            "두번째는 자기 자신은 항상 정지해있다는 것이네.",
            "화면 가운데 정사각형이 바로 자네이네.",
            "무슨 일이 일어나도, 네가 움직이는 것처럼 보여도 (계속)",
            "자네는 항상 정지해 있다네.",
            "이 두 가지를 뺀 나머지는, 차차 설명 하도록 하지.",
            "가장 간단하게, 우클릭을 통해 경로 이동을 해볼것이네.",
            "도착하고 싶은 장소를 우클릭 하면 초록색의 경로가 생길 것이네.",
            "왼쪽 아래 슬라이더를 통해 그 경로의 이동 속도를 조절할 수 있다네.",
            "왼쪽 아래 슬라이더의 수치는 이동할 속도가 빛의 속도의 몇배인지를 조절하지",
            "최대값이 0.9999일세 - 빛의 속도는 넘을 수 없어! 기억하게나.",
            "또, 자네는 항상 정지해있어! 그건 저 이동 속도가 현재 자네를 기준으로 한 속도란 말이야.",
            "그 다음 Start를 누르면 지정한 속도로 경로 목표까지 이동을 한다음 (계속)",
            "이동을 하기 전의 상태로 돌아온다네.",
            "화면에 깜빡이는 고리가 있을테니, 그 고리까지 경로 이동을 통해 이동해보게나.",
            "참고로 마우스 스크롤 휠로 시야의 범위를 넓히거나 좁힐수 있으니 알고 있도록!."
        };

        Todo = "우클릭 경로 이동으로 목표 지점까지 이동.";

        base.Start();


        isCond1 = false;
        isCond2 = false;
        isCond3 = false;

        
    }

    protected override void Update()
    {
        if (XZLengthSquare(player.transform.position, target1.transform.position) < 0.1 && !isCond1)
            Condition1();
        if (XZLengthSquare(player.transform.position, target2.transform.position) < 0.1 && !isCond2)
            Condition2();
        if (XZLengthSquare(player.transform.position, target3.transform.position) < 0.1 && !isCond3)
            Condition3();
        base.Update();


    }

    protected override bool WinCondition()
    {
        if(isCond1 && isCond2 && isCond3)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    protected bool Condition1()
    {
        if (XZLengthSquare(player.transform.position, target1.transform.position) < 0.1 && !isCond1)
        {
            DoubleClickMove = false;
            WASDMove = true;
            PathRenderMove = false;

            isCond1 = true;


            uiManager.WASDMove = WASDMove;
            uiManager.PathCreateAble = PathRenderMove;
            uiManager.DoubleCLickMove = DoubleClickMove;

            ExplanationText = new string[]{"잘했네!",
            "Shift키를 꾹 누르고 우클릭을 다른 장소에 여러번하면 여러 경로를 예약하는 것도 가능하다네.",
            "이동하면서 목표지점 까지의 거리가 줄어드는 것을 보았을 것이네.",
            "그것은 바로 길이 수축이라네.",
            "자네가 보기에 빨리 이동하는 것들은 이동하는 방향으로 길이가 수축되어 보인다네.",
            "여기서 두가지 의미를 구분해야 하네.",
            "자네에게 길이가 수축되어 '보이는 것'과 실제로 길이가 수축되는 것은 엄여히 다르다네",
            "빛의 속도는 유한하기에, 예를 들어 자네가 보기에 1광초 떨어진 것들의 모습은 1초 과거의 모습이지.",
            "자네가 빠르게 움직이면 '실제로' 길이가 수축도 되고, 보기에도 길이가 수축이 되지만, 이 둘의 정도가 다르다네.",
            "시공간이 뒤얽힌 폭풍인 만큼, 이동하면 공간과 시간이 유연하게 바뀌지.",
            "그럼 이제 두번째 이동 방식을 소개해주겠네!",
            "우클릭 말고도, WASD키를 통해 이동을 할 수 있네.",
            "WASD를 사용하면 해당되는 방향으로 등가속 운동을 하게 된다네.",
            "이때 가속도의 크기는 우측 하단의 슬라이더로 조절이 가능하네.",
            "기억하게, 빛의 속도는 넘을수가 없어! 계속 한키를 꾹 누르고 있어도 자네 입장에서만 등가속이지.",
            "다른 가속하지 않는 관측자의 입장에선 계속 빛의 속도의 근접은 하지만 넘지는 않는다네.",
            "즉 점점 가속도가 줄어드는 것처럼 보인다는 것이네.",
            "또한 가속을 멈추면 가속을 멈췄을때 속도로 쭉 움직이네.",
            "관성 때문이지.",
            "이를 고려해서 목적지가 다가오면 감속을 해 멈추는것을 잊지 말도록!",
            "물론 감속을 하면 안되는 경우가 있을수도 있으니 항상 그러라는 것은 아닐세.",
            "이번에도 똑같이 목표 지점을 표시해놨으니 WASD키를 사용해 그곳까지 이동해보게나."
        };

            uiManager.alert.Alert(ExplanationText);

            Todo = "WASD키 이동으로 목표 지점까지 이동";
            uiManager.TodoText = Todo;
            target1.gameObject.SetActive(false);
            return true;
        }
        else
        {
            return false;
        }
    }

    protected bool Condition2()
    {
        if (XZLengthSquare(player.transform.position, target2.transform.position) < 0.1 && !isCond2)
        {
            DoubleClickMove = true;
            WASDMove = false;
            PathRenderMove = false;

            isCond2 = true;

            ExplanationText = new string[]{"오, 이번에도 잘했네!",
            "마지막 이동 방식은 더블클릭 이동일세.",
            "원하는 방향으로 더블클릭을 하면 (계속)",
            "더블클릭한 방향으로 재빨리 가속해 등속 이동을 하게 되지.",
            "이때 등속 이동할 속도는 경로 이동과 마찬가지로 현재 좌측 하단 슬라이더의 값에 의해 결정되네.",
            "자네가 현재 있는 위치의 정확히 왼쪽으로 상당히 멀어서 (계속)",
            "스크롤을 최대로 축소해도 안보이는 거리에 이번에 목표를 두었네.",
            "그 쪽방향으로 대략 0.5c 정도로 조금 가다보면 나올것이네.",
            "너무 빨리 가면, 길이수축이 굉장히 심각해져서 (계속)",
            "아예 목표를 놓쳐버릴수도 있으니 조심하게나!",
            "어서 그곳까지 이동해보게나.",
        };


            uiManager.WASDMove = WASDMove;
            uiManager.PathCreateAble = PathRenderMove;
            uiManager.DoubleCLickMove = DoubleClickMove;

            uiManager.alert.Alert(ExplanationText);


            player.alpha = new Vector3(0, 0, 0);
            player.v = new Vector3(0, 0, 0);


            target2.gameObject.SetActive(false);
            Todo = "더블클릭 이동으로 목표 지점까지 이동";
            uiManager.TodoText = Todo;
            return true;
        }
        else
        {
            return false;
        }
    }

    protected bool Condition3()
    {
        if (XZLengthSquare(player.transform.position, target3.transform.position) < 0.1 && !isCond3)
        {
            DoubleClickMove = true;
            WASDMove = false;
            PathRenderMove = false;

            isCond3 = true;

            ExplanationText = new string[]{"좋았어!",
            "이제 자네는 시공간 폭풍에서 이동의 방식을 마스터하였네.",
            "다음 스테이지 에선 물체들과 상호작용에 대해 알아보도록 하지!",
        };


            uiManager.WASDMove = WASDMove;
            uiManager.PathCreateAble = PathRenderMove;
            uiManager.DoubleCLickMove = DoubleClickMove;

            uiManager.alert.Alert(ExplanationText);


            player.alpha = new Vector3(0, 0, 0);
            player.v = new Vector3(0, 0, 0);


            target2.gameObject.SetActive(false);
            Todo = "";
            uiManager.TodoText = Todo;
            return true;
        }
        else
        {
            return false;
        }
    }

}
