﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using MathNet.Numerics.LinearAlgebra;
using MathNet.Numerics.LinearAlgebra.Double;

public static class Constants
{
    public static double c => 3; // speed of light.
    public static int alphatinterval => 50;
    public static double Gamma(double v)
    {
        return 1.0f / Mathf.Sqrt((float)(1 - ((v / c) * (v / c))));
    }

    public static double RadianToDegree(double r)
    {
        return r * 180 / Mathf.PI;
    }

    public static Matrix<double> BoostMatrix(Vector3 velocity)
    {
        var vmag = velocity.magnitude;
        var gamma = Constants.Gamma(vmag);
        var beta = vmag / Constants.c;
        var betax = velocity.x / Constants.c;
        var betay = velocity.z / Constants.c;
        double[,] tmp = { { gamma, -gamma * betax, -gamma * betay}, 
                          { -gamma * betax, 1.0+(gamma - 1.0)*(betax*betax)/(beta*beta) , (gamma - 1.0) * (betax*betay)/(beta*beta)}, 
                          { -gamma * betay, (gamma - 1.0) * (betay*betax)/(beta*beta), 1.0+(gamma - 1.0)*(betay*betay)/(beta*beta)} };
        var M = Matrix<double>.Build;
        var result = M.DenseOfArray(tmp);
        return result;
    }

}
