﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UnityEngine;

public class Clock : GrabableObject
{
    public double starttime = 0.0f;
    public Clock otherclock;

    private new void Start()
    {
        base.Start();
        time = starttime;
    }

    public override void OnCollisionStaychild(Collision collision)
    {
        base.OnCollisionStaychild(collision);
        //Debug.Log("hit!");
        //if(collision.transform.parent.name != "AnObject(Clone)")
        //    Debug.Log(collision.gameObject.name + " wow!");
        if (collision.transform.parent != null)
        {
            var x = collision.transform.parent.gameObject.GetComponent(typeof(Clock)) as Clock;
            if (x != null && x.Equals(otherclock))
            {
                Debug.Log("hit!");
                if (Mathf.Abs((float)(otherclock.GetTime() - time)) <= 1.0f)
                {
                    levelManager.winstate = true;
                }
                else
                {
                    Debug.Log(Mathf.Abs((float)(otherclock.GetTime() - time)));
                }
            }
        }

    }

    public double GetTime()
    {
        return time;
    }
}


