﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
public class UIManager : MonoBehaviour
{
    public Text properTime;
    public Text currentSpeed;
    public Text clockText;
    public Square square;
    public FlatLandObject clock1, clock2;
    public GameObject victoryScreen;
    float curZoomPos = 95.0f;

    public void UpdateUI() // it just updates UI.
    {
        double newPropertime, prevPropertime;

        currentSpeed.text = "Current Speed : " + (square.gameSpeed / Constants.c).ToString("F2") + "c";

        prevPropertime = square.CalculateEntireMovingTime();
        newPropertime = (square.CalculateEntireMovingTime() / Constants.Gamma(square.gameSpeed));

        properTime.text = "ETA(you) : " + newPropertime.ToString("+0;-#") + " seconds\nETA(start frame) : " + prevPropertime.ToString("+0;-#") + " seconds\nΔt : " + (newPropertime - prevPropertime).ToString("+0;-#") + " seconds";

        clockText.text = "Clock1 : " + clock1.properTime + " seconds\nClock2 : " + clock2.properTime + " seconds";
    }

    public void Update()
    {
        float y = Input.mouseScrollDelta.y;
        curZoomPos -= y*20;

        curZoomPos = Mathf.Clamp(curZoomPos, 40f, 400f);

        // Makes the actual change to Field Of View
        Camera.main.orthographicSize = curZoomPos;
    }

    public void CheckVictory()
    {
        if ((clock1.transform.position - clock2.transform.position).sqrMagnitude < 20 && Mathf.Abs((float)(clock1.properTime - clock2.properTime)) < 1)
            victoryScreen.SetActive(true);
    }
}
