﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;
using UnityEngine.SceneManagement;
using System.Linq;

public class Square : FlatLandObject
{

    public LineRenderer pathRenderer; // About drawing paths.
    public List<GameObject> pathPositionObjects = new List<GameObject>();
    public List<Vector2> pathList = new List<Vector2>();
    public UIManager uiManager;
    public GameObject Background;
    public float backgroundSize = 400.0f;

    public List<FlatLandObject> allObjects = new List<FlatLandObject>(); // Evety FlatLandObject is automatically added with Awake().
    public FlatLandObject attatchedObject = null;

    private Vector2 _currentPathEnd;

    // Start is called before the first frame update
    void Start()
    {
    }

    // Update is called once per frame
    public void Update()
    {
        if(Input.GetMouseButtonDown(1)) // If right mouse button is clicked
        {
            Ray ray = Camera.main.ScreenPointToRay(Input.mousePosition);
            if (Physics.Raycast(ray, out RaycastHit hit)) // If the click was on the background
            {
                if (Input.GetKey(KeyCode.LeftShift) && pathPositionObjects.Count >= 1) // If shift is clicked and path is already exists
                    AddPath(hit.point);
                else
                    CreatePath(hit.point);
            }
        }

        if (Input.GetKeyDown(KeyCode.G))
            Grab();

        if (Input.GetKeyDown(KeyCode.H))
            Detach();
    }

    public IEnumerator MoveSquare(GameObject destination)
    {
        Vector2 dest = new Vector2(destination.transform.position.x, destination.transform.position.y);
        Vector2 start = new Vector2(transform.position.x, transform.position.y);
        speedVector = dest - start;
        Vector2 prevFrameSpeedVector = speedVector;
        //Vector2 ndest = (Vector2)transform.position + (speedVector / (float)Constants.Gamma(gameSpeed));
        Vector3 scaledVector = speedVector * Time.deltaTime;
        LengthContraction(scaledVector);
        dest = new Vector2(destination.transform.position.x, destination.transform.position.y);
        start = new Vector2(transform.position.x, transform.position.y);
        speedVector = dest - start;
        scaledVector = speedVector * Time.deltaTime;
        while (speedVector.x * (destination.transform.position.x - transform.position.x) > 0 || speedVector.y * (destination.transform.position.y - transform.position.y) > 0)
        {
            transform.position += scaledVector;
            if (attatchedObject != null)
                attatchedObject.gameObject.transform.position += scaledVector;
            yield return null;
        }
        Background.transform.localScale = new Vector3(backgroundSize, backgroundSize, 1.0F);
        Background.transform.position = new Vector3(Background.transform.localPosition.x, Background.transform.localPosition.y, 0.0f);
        //RemoveFromBackground();
        Background.transform.DetachChildren();
        //pathRenderer.transform.position = new Vector3(0.0f, 0.0f, -2.0f);
        Background.transform.position = destination.transform.position;
        //Background.transform.localPosition += (Vector3)speedVector;
        //Background.transform.localPosition += (Vector3)speedVector;
        AddtoBackground();
        Background.transform.position = transform.position;
        Background.transform.position = new Vector3(Background.transform.position.x, Background.transform.position.y, 0.0f);
        //Background.transform.DetachChildren();
        //Background.transform.localEulerAngles = new Vector3(0.0F, 0.0F, 0.0F);
        //Background.transform.LookAt(-Vector3.forward);
        //AddtoBackground();
        //RemoveFromBackground();
        Background.transform.DetachChildren();
        Background.transform.position = new Vector3(Background.transform.position.x, Background.transform.position.y, 0.0f);
        //pathRenderer.transform.position = new Vector3(0.0f, 0.0f, -2.0f);
        yield return null;
    }

    public void LengthContraction(Vector3 scaledVector) // length contraction - find all flatlandobjects not grabbed by the square, add them to the rotated background and squeeze
    {
        //Background.transform.localPosition = new Vector3(transform.localPosition.x, transform.localPosition.y, Background.transform.localPosition.z);
        Background.transform.rotation = Quaternion.LookRotation(Vector3.forward, scaledVector);
        //Background.transform.LookAt(new Vector3(0.0f,0.0f,1.0f),scaledVector);
        AddtoBackground();

        Background.transform.localScale = new Vector3(backgroundSize, (float)(1 / Constants.Gamma(gameSpeed)) * backgroundSize, 1.0F);
    }
    public void AddtoBackground()
    {
        List<GameObject> rootObjects = new List<GameObject>();
        Scene scene = SceneManager.GetActiveScene();
        scene.GetRootGameObjects(rootObjects);

        foreach (GameObject anobject in rootObjects)
        {
            if (anobject.GetComponent<FlatLandObject>() != null && anobject.GetComponent<Square>() == null)
            {
                if (attatchedObject != null && anobject == attatchedObject.gameObject)
                    continue;
                else
                {
                    anobject.transform.parent = Background.transform;
                }
            }
        }
        pathRenderer.transform.parent = Background.transform;
    }

    public void RemoveFromBackground()
    {
        foreach(Transform t in Background.transform)
        {
            Vector3 realposition = t.position;
            Quaternion realrotation = t.rotation;
            Vector3 realscale = t.lossyScale;
            Transform a = t;
            t.parent = null;
            a.localPosition = realposition;
            a.localRotation = realrotation;
            a.localScale = realscale;
        }
    }

    public void CreatePath(Vector3 point) // Creates the fitst path, and updates Proper Time UI.
    {
        ResetPaths();
        pathRenderer.positionCount = 2;
        pathRenderer.SetPositions(new Vector3[] { transform.position, point });
        pathRenderer.material.color = Color.green;

        GameObject wow = new GameObject("Point1"); //turn the destination point into a gameobject for length contraction scaling
        wow.transform.parent = null;
        wow.transform.localPosition = new Vector3(point.x, point.y, 0.0f);
        wow.AddComponent<FlatLandObject>();
        pathPositionObjects.Add(wow);

        uiManager.UpdateUI();
    }

    public void AddPath(Vector3 point) // Adds new path to current path, and updates Proper Time UI.
    {
        pathRenderer.positionCount++;
        pathRenderer.SetPosition(pathRenderer.positionCount - 1, point);

        GameObject wow = new GameObject("Point" + (pathRenderer.positionCount - 1), typeof(FlatLandObject));
        wow.transform.parent = null;
        wow.transform.localPosition = new Vector3(point.x, point.y, 0.0f);
        pathPositionObjects.Add(wow);

        uiManager.UpdateUI();
    }

    public void Move()
    {
        StartCoroutine(_StartMovingPath());
    }


    public IEnumerator _StartMovingPath()
    {
        //Vector3[] tomoveList = new Vector3[pathRenderer.positionCount];
        //pathRenderer.GetPositions(tomoveList);
        //Vector3[] tomoveList = new Vector3[pathRenderer.positionCount - 1];

        //for(int i = 1; i < pathRenderer.positionCount; i++)
        //{
            //yield return StartCoroutine(MoveSquare(tomoveList[i]));
        //}
        foreach(GameObject wow in pathPositionObjects)
        {
            yield return StartCoroutine(MoveSquare(wow));
            //Background.transform.position = transform.position;
        }

        AddTimes();
        ResetPaths();
        uiManager.UpdateUI();
        uiManager.CheckVictory();
    }

    public void ResetPaths()
    {
        pathRenderer.positionCount = 2;
        pathRenderer.SetPositions(new Vector3[] { Vector3.zero, Vector3.zero });
        foreach(GameObject j in pathPositionObjects)
        {
            Destroy(j);
        }
        pathPositionObjects = new List<GameObject>();
        pathRenderer.transform.localPosition = Vector3.zero;
    }

    public Vector2 getNthPath(int n) // returns movement vector stored in path renderer by index.
    {
        if (n >= pathRenderer.positionCount)
            throw new InvalidOperationException(n + "the path is not stored.");

        return pathRenderer.GetPosition(n + 1) - pathRenderer.GetPosition(n);
    }

    public double MovingTime(Vector2 v) // How long it takes to move given vector with current speed.
    {
        return v.sqrMagnitude / gameSpeed;
    }

    public double CalculateEntireMovingTime() // How long it takes to move current path all the way.
    {
        double result = 0;
        for (int i = 0; i < pathRenderer.positionCount - 1; i++)
            result += MovingTime(getNthPath(i));

        return result / gameSpeed;
    }

    public void ModifySpeed(float d)
    {
        if (gameSpeed + d <= Constants.c && gameSpeed + d >= 0)
            gameSpeed += d;
        uiManager.UpdateUI();
    }

    public void Grab()
    {
        var lst = Physics.OverlapSphere(transform.position, 10);

        if (lst.Length > 0)
        {
            foreach(Collider thing in lst)
            {
                if (thing.gameObject.GetComponent<FlatLandObject>() != null)
                {
                    attatchedObject = thing.gameObject.GetComponent<FlatLandObject>();
                    break;
                }
            }
        }
    }

    public void Detach()
    {
        attatchedObject = null;
    }

    public void AddTimes()
    {
        Debug.Log(CalculateEntireMovingTime());
        foreach (var v in allObjects)
        {
            Debug.Log(v.gameObject.name);
            v.properTime += CalculateEntireMovingTime();
        }
        square.properTime -= CalculateEntireMovingTime() - (square.CalculateEntireMovingTime() / Constants.Gamma(square.gameSpeed));

        if (attatchedObject != null)
            attatchedObject.properTime -= CalculateEntireMovingTime() - (square.CalculateEntireMovingTime() / Constants.Gamma(square.gameSpeed));
    }
}
