﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System.Linq;
using UnityEngine.UI;
using System;
using MathNet.Numerics.LinearAlgebra;
using MathNet.Numerics.LinearAlgebra.Double;

public class PathRenderer : MonoBehaviour
{
    [SerializeField]
    Square square;
    [SerializeField]
    GameObject PathColliderPrefab;
    [SerializeField]
    Camera playercamera;
    [SerializeField]
    LevelManager levelManager;
    [SerializeField]
    BackgroundMovement background;
    [SerializeField]
    LogScaleSlider velocityslider;
    [SerializeField]
    UIManager ui;

    LineRenderer _pathRenderer;
    float _originalPathColliderY;

    public BackgroundMovement Background
    {
        get
        {
            return background;
        }
        set
        {
            background = value;
        }
    }

    // Start is called before the first frame update
    void Start()
    {
        _originalPathColliderY = PathColliderPrefab.transform.localScale.y / 2;

        _pathRenderer = GetComponent<LineRenderer>();
        _ResetPaths();
    }

    // Update is called once per frame
    void Update()
    {
        if (Input.GetMouseButtonDown(1) && levelManager.player.isInertial())
        {
            RaycastHit hit1;
            var ray = Camera.main.ScreenPointToRay(Input.mousePosition);

            if (Physics.Raycast(ray, out hit1))
            {
                RaycastHit hit2;
                ray = playercamera.ViewportPointToRay(hit1.textureCoord);
                if (Physics.Raycast(ray, out hit2))
                {
                    if (Input.GetKey(KeyCode.LeftShift))
                    {
                        _DrawMorePath(hit2.point, hit1);
                    }
                    else
                    {
                        _DrawOnePath(hit2.point, hit1);
                    }
                }
            }
            /*if (Physics.Raycast(ray, out hit))
            {
                if (Input.GetKey(KeyCode.LeftShift))
                {
                    _DrawMorePath(hit.point);
                }
                else
                {
                    _DrawOnePath(hit.point);
                }
            }*/
        }
    }

    private void _DrawOnePath(Vector3 point, RaycastHit hit)
    {
        _ResetPaths();
        square.pathList[0] = transform.localPosition;
        square.pathVelocity[0] = 0.0f;
        var tmp = transform.InverseTransformPoint(point);
        square.pathList.Add(new Vector3(tmp.x, tmp.y, 0.0f));
        square.pathVelocity.Add(velocityslider.GetLogScaleValue());
        _pathRenderer.positionCount = square.pathList.Count();
        _pathRenderer.SetPositions(square.pathList.ToArray());
        _InstantiatePathCollider(0);
        ui.PopupLastPathUI(_pathRenderer.positionCount - 2, hit);
    }

    private void _ResetPaths()
    {
        _pathRenderer.positionCount = 1;
        square.pathList.Clear();
        square.pathVelocity.Clear();
        square.pathList.Add(transform.localPosition);
        square.pathVelocity.Add(0.0f);
        _pathRenderer.SetPositions(square.pathList.ToArray());
        for (int i = 0; i < transform.childCount; i++)
        {
            Destroy(transform.GetChild(i).gameObject);
        }
    }

    private void _DrawMorePath(Vector3 point, RaycastHit hit)
    {
        if (square.pathList.Count == 0)
        {
            _DrawOnePath(point, hit);
        }
        else
        {
            var tmp = transform.InverseTransformPoint(point);
            square.pathList.Add(new Vector3(tmp.x, tmp.y, 0.0f));
            square.pathVelocity.Add(velocityslider.GetLogScaleValue());
            _pathRenderer.positionCount = square.pathList.Count();
            _pathRenderer.SetPositions(square.pathList.ToArray());
            _InstantiatePathCollider(square.pathList.Count() - 2);
            ui.PopupLastPathUI(_pathRenderer.positionCount - 2, hit);
        }
    }

    public void PathClear()
    {
        _ResetPaths();
    }

    /// <summary>
    /// 현재 설정된 경로를 반환.
    /// 0번은 내 위치
    /// x y 가 공간 z 가 시간
    /// </summary>
    public List<Vector3> PathPositionsXY
    {
        get
        {
            return square.pathList;
        }
    }
    /// <summary>
    /// 현재 설정된 경로를 반환.
    /// 0번은 현재위치 //패트롤 고려
    /// x z 가 공간 y 가 시간
    /// </summary>
    public List<Vector3> PathPositionsXZ
    {
        get
        {
            List<Vector3> list = new List<Vector3>();

            foreach (var a in square.pathList)
            {
                //xy -> xz
                list.Add(new Vector3(a.x, 0, a.y));
            }

            return list;
        }
    }
    /// <summary>
    /// 현재 설정된 경로의 속력을 반환.
    /// 0번은 0.0f
    /// </summary>
    public List<float> PathVelocities
    {
        get
        {
            return new List<float>(square.pathVelocity);
        }
    }
    private void _InstantiatePathCollider(int n)
    {
        var _pathCollider = Instantiate(PathColliderPrefab, transform);
        _pathCollider.name = "PathCollider-" + n;
        _pathCollider.tag = "path";
        _pathCollider.transform.localScale = new Vector3(0.1f, _originalPathColliderY, 0);
        _pathCollider.transform.localEulerAngles = new Vector3(0, 0,
            (float)Constants.RadianToDegree(Mathf.PI / 2 +
                Mathf.Atan
                (square.GetTangent(
                    square.GetNthPath(n)))));

        float _newY = square.GetNthPath(n).magnitude;
        _pathCollider.transform.localScale = new Vector3(0.1f, _newY * _originalPathColliderY, 0);

        _pathCollider.transform.localPosition = (square.pathList[n] + square.pathList[n + 1]) / 2;
    }

    public IEnumerator _StartMovingPath(int finalPathNum)
    {
        int i = 0;
        var u = levelManager.player.v;
        int tinterval = Constants.alphatinterval;
        VectorBuilder<double> V = Vector<double>.Build;

        //square.PathList에서 0에서 시작해 finalPathNum까지 이동

        while (i <= finalPathNum)
        {
            Vector3 startpos = new Vector3(levelManager.player.transform.position.x, 0, levelManager.player.transform.position.z); // 경로 이동 시작할때 위치
            Vector3 dest = new Vector3(square.GetNthPath(i).x, 0f, square.GetNthPath(i).y); // 시작 관성계 기준 startpos에서 목표지점까지 공간 좌표
            Vector3 acceleration = dest.normalized;

            var v = square.GetPathVelocity(i);

            var atmp = (float)(v * Constants.c);

            double[] vtmp = { (atmp * (acceleration.x / acceleration.magnitude)), 0.0, (atmp * (acceleration.z / acceleration.magnitude)) };
            double[] xtmp = { dest.magnitude / (v), dest.x, dest.z };
            var deltavnaive = V.DenseOfArray(vtmp);
            var deltaxnaive = V.DenseOfArray(xtmp);

            double[] tmp = {Constants.c * Constants.Gamma(deltavnaive.L2Norm()),
                      deltavnaive[0] * Constants.Gamma(deltavnaive.L2Norm()),
                      deltavnaive[2] * Constants.Gamma(deltavnaive.L2Norm())};

            var deltav = V.DenseOfArray(tmp);

            Vector<double> deltax = deltaxnaive;

            if (u.magnitude > 0.0f)
            {
                deltav = Constants.BoostMatrix(-u) * deltav; // 로렌츠 행렬을 곱해서 경로 이동시 속도가 월드 관성계에서 무슨 속도인지 구함(deltav)
                deltax = Constants.BoostMatrix(-u) * deltaxnaive; // 로렌츠 행렬을 곱해서 경로 이동시 위치 변화가 월드 관성계에서 얼마나 되는지 구함(deltax)
            }

            var tt = deltav[0] / Constants.c;

            Vector3 finaldeltav = new Vector3((float)(deltav[1] / tt), 0.0f, (float)(deltav[2] / tt));
            Vector3 finaldeltax = new Vector3((float)deltax[1], 0.0f, (float)deltax[2]);

            levelManager.player.v = finaldeltav; // 플레이어 월드 관성계 기준 속도를 deltav로 세팅

            while (true)
            {
                var currentpos = new Vector3(levelManager.player.transform.position.x, 0, levelManager.player.transform.position.z);
                var traveledpos = currentpos - startpos;
                if (traveledpos.magnitude >= finaldeltax.magnitude)
                {
                    break;
                }
                yield return new WaitForFixedUpdate();
            }
            

            levelManager.player.v = u; // 원래 관성계로 돌아옴
            levelManager.player.transform.position = new Vector3(startpos.x + finaldeltax.x
                                                               , levelManager.player.transform.position.y
                                                               , startpos.z + finaldeltax.z); // 위치 보정해줌(fixed update오차)



            // INSERT CODE TO REMOVE PATH FROM PATH RENDERER HERE
            // 여기에 방금 이동한 경로를 안보이게 해야 함

            i++;
        }

        Background.Toggle = true;

        //아마 여기에 이동을 다 마친 경로들을 square.pathList랑 square.pathVelocity에서 없애주고, finalPathNum 다음 경로가 square.pathList[1]이 되게 해야할듯
        // PathRenderer에 child로 되 있는 Path-n들 이름도 다 바꿔줘야 할꺼임(니가 최종 경로 가 몇번째인지 판정으로 GameObject 이름을 string으로 받아와서 하니까)
        // 귀찮으면 아예 UIManager.cs에서 int pathNum = int.Parse(obj.name.Substring(13)); 이부분을 바꿔도 됨.

    }

    public void DeletePathsAfterNthPath(int n)
    {
        square.pathList.RemoveRange(n, _pathRenderer.positionCount - n);
        square.pathVelocity.RemoveRange(n, _pathRenderer.positionCount - n);
        for (int i = 0; i < transform.childCount; i++)
        {
            if (i + 1 >= n) Destroy(transform.GetChild(i).gameObject);
        }
        _pathRenderer.positionCount = square.pathList.Count();
    }
}
