﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class LevelManager : MonoBehaviour
{

    public UIManager uiManager;

    public double gamma;
    public PlayerMovement player;
    [SerializeField]
    protected bool winstate = false;
    // Start is called before the first frame update
    void Start()
    {
        winstate = false;
    }

    // Update is called once per frame
    void Update()
    {
        if (WinCondition())
        {
            WinState = true;
        }

        if (LoseCondition())
        {
            WinState = false;
        }
    }

    protected virtual void OnWin()
    {
        uiManager.WinTextOn();
    }

    protected virtual void OnLose()
    {

    }

    protected virtual bool LoseCondition()
    {
        return false;
    }

    protected virtual bool WinCondition()
    {
        return false;
    }
    public virtual bool WinState
    {
        set
        {
            if (value)
            {
                //if win
                OnWin();
            }
            else
            {
                //if lose
                OnLose();
            }
        }
    }
}
