﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.EventSystems;

public class DoubleClick : MonoBehaviour, IPointerClickHandler
{


    private bool click = true;   //클릭 여부 
    [SerializeField]
    private float clickWaitTime = 0.5f;    //클릭 대기시간  

    private float clickTime;

    public UIManager uiManager;

    public 
    // Start is called before the first frame update
    void Start()
    {

    }

    // Update is called once per frame
    void Update()
    {
        if (Time.time > clickTime + clickWaitTime)
        {
            click = false;
        }
    }

    public void OnPointerClick(PointerEventData eventData)
    {
        if (eventData.button == PointerEventData.InputButton.Left)
        {
            OnClick();
            //Debug.Log("Left click");
        }
        else if (eventData.button == PointerEventData.InputButton.Middle)
        {
            //Debug.Log("Middle click");
        }
        else if (eventData.button == PointerEventData.InputButton.Right)
        {
            //Debug.Log("Right click");
        }
    }

    public void OnClick()
    {
        /*
        if(eventData.button != PointerEventData.InputButton.Left)
        {
            return;
        }*/
        if (click)
        {
            OnDoubleClick();
            click = false;
        }
        else
        {
            //Debug.Log("single");
            click = true;
            clickTime = Time.time;
        }
    }

    private void OnDoubleClick()
    {
        uiManager.OnDoubleClicked();
    }
}
