﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine.EventSystems;
using UnityEngine;
using UnityEngine.UI;
using System;
using System.Linq;

public class UIManager : MonoBehaviour
{
    [SerializeField]
    Square square;
    [SerializeField]
    Camera playercamera;
    [SerializeField]
    LogScaleSlider velocityslider;

    public Canvas canvas;
    public Text mytime;
    //public Planemovement clock1;
    //public Planemovement clock2;
    //public Text clock1time;
    //public Text clock2time;
    public Text wintext;
    public GameObject _pathUI;
    public LevelManager Levelmanager;

    private int prevSelectPathNum = -1;
    private Text pathName;
    private Text pathVeclocity;
    private Vector3 middlePoint;
    private Vector3 canvasSize;
    private int sliderflag = 0;

    GraphicRaycaster gr;
    PointerEventData ped;

    // Start is called before the first frame update
    void Start()
    {
        _pathUI.SetActive(false);
        pathName = _pathUI.transform.Find("Name").GetComponent<Text>();
        pathVeclocity = _pathUI.transform.Find("Velocity").GetComponent<Text>();
        middlePoint = _pathUI.transform.position;
        canvasSize = new Vector3(Screen.width, Screen.height, 0);

        gr = canvas.GetComponent<GraphicRaycaster>();
        ped = new PointerEventData(null);
    }

    // Update is called once per frame
    void Update()
    {
        mytime.text = Levelmanager.player.time.ToString() + " s";
        //clock1time.text = clock1.GetTime().ToString() + " s";
        //clock2time.text = clock2.GetTime().ToString() + " s";
        if(Levelmanager.winstate)
        {
            wintext.gameObject.SetActive(true);
        }
        if (Input.GetMouseButtonDown(0))
        {
            ped.position = Input.mousePosition;
            List<RaycastResult> results = new List<RaycastResult>();
            gr.Raycast(ped, results);
            if (results.Count != 0)
            {
                GameObject obj = results[0].gameObject;

                if(obj.tag == "VelocitySlider")
                {
                    sliderflag = 1;
                    if (_pathUI.activeSelf == true && prevSelectPathNum != -1)
                    {
                        square.pathVelocity[prevSelectPathNum + 1] = velocityslider.GetLogScaleValue();
                        pathVeclocity.text = "Velocity: " + square.GetPathVeclocity(prevSelectPathNum).ToString() + "c";
                    }
                }
            }

            else
            {
                RaycastHit hit1;
                RaycastHit hit2;
                var ray = Camera.main.ScreenPointToRay(Input.mousePosition);

                if (Physics.Raycast(ray, out hit1))
                {
                    ray = playercamera.ViewportPointToRay(hit1.textureCoord);
                    if (Physics.Raycast(ray, out hit2))
                    {
                        var obj = hit2.collider.gameObject;

                        if (obj.tag == "path")
                        {
                            int pathNum = int.Parse(obj.name.Substring(13));

                            if (pathNum != prevSelectPathNum)
                            {
                                updatePathInfo(obj, pathNum);

                                var mouseClickPosition = getMouseClickPosition(hit1);
                                var v = getDestVector(mouseClickPosition - middlePoint, new Vector3(hit2.point.x, hit2.point.z, 0.0f), pathNum);

                                _pathUI.transform.position = mouseClickPosition + v;
                                _pathUI.SetActive(true);

                                prevSelectPathNum = pathNum;
                            }
                            else
                            {
                                _pathUI.SetActive(false);
                                prevSelectPathNum = -1;
                                sliderflag = 0;
                            }
                        }
                        else
                        {
                            _pathUI.SetActive(false);
                            prevSelectPathNum = -1;
                            sliderflag = 0;
                        }
                    }
                }
            }
        }
        else if(sliderflag == 1 && Input.GetMouseButton(0))
        {
            if (_pathUI.activeSelf == true && prevSelectPathNum != -1)
            {
                square.pathVelocity[prevSelectPathNum + 1] = velocityslider.GetLogScaleValue();
                pathVeclocity.text = "Velocity: " + square.GetPathVeclocity(prevSelectPathNum).ToString() + "c";
            }
        }
        else if (Input.GetMouseButtonDown(1))
        {
            _pathUI.SetActive(false);
            prevSelectPathNum = -1;
            sliderflag = 0;
        }
    }

    private Vector3 getMouseClickPosition(RaycastHit hit)
    {
        var tmp = Camera.main.WorldToScreenPoint(hit.point);
        return tmp - canvasSize * 0.5f + middlePoint;
    }

    private Vector3 getDestVector(Vector3 hitVector1, Vector3 hitVector2, int pathNum)
    {
        hitVector1.z = 0;
        var v = square.GetDestPoint(pathNum) - hitVector2;
        var k = hitVector1.magnitude / hitVector2.magnitude;

        return k * v;
    }

    private void updatePathInfo(GameObject obj, int pathNum)
    {
        pathName.text = obj.name;
        pathVeclocity.text = "Velocity: " + square.GetPathVeclocity(pathNum).ToString() + "c";
        velocityslider.UpdateValuebyVelocity(square.GetPathVeclocity(pathNum));
    }
}
