﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class AlertManager : MonoBehaviour
{
    [SerializeField]
    GameObject alertObject;
    [SerializeField]
    Button okButton;
    [SerializeField]
    Button cancelButton;
    [SerializeField]
    Text alertText;
    // Start is called before the first frame update
    void Start()
    {
        Close();
        Alert("test");
    }

    // Update is called once per frame
    void Update()
    {
        
    }

    public void Alert(string text)
    {
        Open();
        alertText.text = text;
        okButton.onClick.AddListener(Close);
        cancelButton.onClick.AddListener(Close);
    }

    public void Open()
    {
        alertObject.SetActive(true);
    }
    public void Close()
    {
        okButton.onClick.RemoveAllListeners();
        cancelButton.onClick.RemoveAllListeners();
        alertObject.SetActive(false);
    }
}
