﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;
using System.Linq;

public class Square : FlatLandObject
{
    public List<Vector3> pathList = new List<Vector3>();
    public List<float> pathVelocity = new List<float>();
    private float _zPosition => transform.position.z;
    private float PlayerVelocity;

    public Vector3 GetNthPath(int n) // Get a path from (n)th destination to (n+1)th destination.
    {
        return pathList[n + 1] - pathList[n];
    }

    public float GetTangent(Vector3 v)
    {
        return v.y / v.x;
    }

    public Vector3 GetDestPoint(int n)
    {
        return pathList[n + 1];
    }

    public float GetPathVelocity(int n)
    {
        return pathVelocity[n + 1];
    }
}
