﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using Assets.Scripts.Interface;

public class GrabableObject : InteractiveObject,IGrabable
{


    protected bool toggle = false;
    protected bool grabbed = false;

    protected IGraber graber;

    public override string InteractType
    {
        get
        {
            return "grab";
        }
    }

    public bool IsGrabbed
    {
        get
        {
            return grabbed;
        }
    }

    public void OnDisGrabbed(IGraber graber)
    {
        grabbed = false;
        v = Vector3.zero;
    }



    public void OnGrabbed(IGraber graber)
    {
        grabbed = true;
    }

    public override void OnInteract(IInteractor interactor)
    {
        if (interactor.IsGraber != null)
        {
            graber = interactor.IsGraber;
            if (!graber.IsGrab)
            {
                graber.OnGrab(this);
                OnGrabbed(graber);
            }
        }
    }

    public override void OnDisInteract(IInteractor interactor)
    {
        if (interactor.IsGraber != null)
        {
            graber = interactor.IsGraber;
            if (graber.IsGrab)
            {
                graber.OnDisGrab(this);
                OnDisGrabbed(graber);
            }
        }
    }

    protected override void FixedUpdate()
    {

        if (grabbed)
        {
            v = graber.GraberV;
            Debug.Log("being grabbed");
        }

        base.FixedUpdate();
    }
}
