﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class LaserLevelManager : LevelManager
{
    double time = 0;
    // Start is called before the first frame update
    protected override void Start()
    {
        ExplanationText = new string[]{"오! 시공간 폭풍 속에서 자네를 또 만나게 되었군!",
            "이번엔 적수로 만나게 된것 같네.",
            "자네가 시공간 폭풍에 의해 선택을 받았다고 해서 내가 봐주지는 않을 것일세.",
            "자네가 볼수 있다시피 자네는 3방면에서 같혀있네.",
            "그리고 빛의 수호자 나는 강력한 빛을 쏘는 이 붉은 레이저 포를 가지고 있지.",
            "그 어떤 것도 빛보다는 빨리 이동할수 없지!",
            "심지어 자네는 내가 언제 레이저를 쐈는지도 알수 없다네.",
            "대략 15초 뒤에 레이저를 쏠테니 한 번 잘 피해 보게나!",
            "게다가 이 레이저는 이 푸른 통로의 두께만큼 크다네.",
            "아무리 자네라도 벗어날 수는 없을 것일세!"
        };

        uiManager.alert.Alert(ExplanationText);

        Todo = "15초뒤 통로를 따라 쏴지는 레이저 살아남기";
        uiManager.TodoText = Todo;

        base.Start();
        time = 0;
    }

    // Update is called once per frame
    protected override void Update()
    {
        if (Input.GetKey("d"))
        {
            time += Time.deltaTime;
        }
        if (Input.GetKeyUp("d"))
            time = 0;
        if (WinCondition())
            WinMessage();
        base.Update();
    }

    protected override bool WinCondition()
    {
        if (time > 10.0)
        {
            return true;
        }
        else
            return false;
    }

    protected override bool LoseCondition()
    {
        if (base.player.time > 15.0)
            return true;
        else return false;
    }

    protected bool WinMessage()
    {
        ExplanationText = new string[]{"... 말도 안되, 어떻게 빛보다 계속 느린데 내 레이저가 따라 잡을 수 없지?",
            "역시 시공간 폭풍의 선택을 받은 영웅은 다르군.",
            "나의 패배일세."
        };

        uiManager.alert.Alert(ExplanationText);

        Todo = "";
        uiManager.TodoText = Todo;
        return true;
    }
}
