﻿using UnityEngine;
using UnityEngine.TestTools;
using NUnit.Framework;
using System.Collections;

class CoordinateMapperViewTests
{
    // TODO: Reduce warning factors
    [UnityTest]
    public IEnumerator MainTexture_Equal_Texture_Generate_By_Shader_When_After_Update()
    {
        var tmpObj = CreatePlaneWithShader();

        var manager = CreateManager();

        var material = tmpObj.GetComponent<Renderer>().material;
        material.SetTexture("_MainTex", manager.ColorTexture);

        var DepthPoints = manager.DepthCoordinates;
        var DepthBuffer = new ComputeBuffer(DepthPoints.Length, sizeof(float) * 2);
        material.SetBuffer("depthCoordinates", DepthBuffer);

        var BodyIndexPoints = manager.BodyIndexBuffer;
        var BodyIndexBuffer = new ComputeBuffer(BodyIndexPoints.Length, sizeof(float));
        material.SetBuffer("bodyIndexBuffer", BodyIndexBuffer);

        var coordinateMapperView = CreatePlaneWithShader();
        var CoordinateMapperView = coordinateMapperView.AddComponent<CoordinateMapperView>();

        yield return null;

        var expected = material.mainTexture;
        Object.Destroy(tmpObj);
        DepthBuffer.Release();
        BodyIndexBuffer.Release();

        var actual = CoordinateMapperView.GetComponent<Renderer>().material.mainTexture;

        Assert.AreEqual(expected, actual, "texture of gameobject should be same as texture which made by shader.");
    }

    CoordinateMapperManager CreateManager()
    {
        var manager = new GameObject("Managers");
        return manager.AddComponent<CoordinateMapperManager>();
    }

    GameObject CreatePlaneWithShader()
    {
        var tmpObj = GameObject.CreatePrimitive(PrimitiveType.Plane);
        tmpObj.GetComponent<Renderer>().material = Resources.Load("GreenScreen/GreenScreen.mat", typeof(Material)) as Material;

        return tmpObj;
    }
}
