﻿using UnityEngine;
using UnityEngine.TestTools;
using NUnit.Framework;
using System.Collections;
using Windows.Kinect;
using System.Runtime.InteropServices;
using System;

// TODO: Change IMGUI to uGUI
public class CoordinateMapperManagerTests
{    
    [UnityTest]
    public IEnumerator ColorTexture_Not_Equal_Null_When_Kinect_Disconnected()
    {
        var comp = InactiveComponent();

        yield return null;

        var expected = null as Texture2D;
        var actual = comp.ColorTexture;

        Assert.AreNotEqual(expected, actual, "ColorTexture should not be null value when kinect disconnected.");
    }

    [UnityTest]
    public IEnumerator ColorTexture_Not_Equal_Null_When_Kinect_Connected()
    {
        var comp = ActiveComponent();
        
        yield return null;

        var expected = null as Texture2D;
        var actual = comp.ColorTexture;
        
        Assert.AreNotEqual(expected, actual, "ColorTexture should not be null value when kinect connected.");

        Application.Quit();
    }

    [UnityTest]
    public IEnumerator BodyIndexBuffer_Not_Equal_Null_When_Kinect_Disconnected()
    {
        var comp = InactiveComponent();

        yield return null;

        var expected = null as byte[];
        var actual = comp.BodyIndexBuffer;

        Assert.AreNotEqual(expected, actual, "BodyIndexBuffer should not be null value when kinect disconnected.");
    }

    [UnityTest]
    public IEnumerator BodyIndexBuffer_Not_Equal_Null_When_Kinect_Connected()
    {
        var comp = ActiveComponent();

        yield return null;

        var expected = null as byte[];
        var actual = comp.BodyIndexBuffer;

        Assert.AreNotEqual(expected, actual, "BodyIndexBuffer should not be null value when kinect connected.");
    }

    [UnityTest]
    public IEnumerator DepthCoordinates_Not_Equal_Null_When_Kinect_Disconnected()
    {
        var comp = InactiveComponent();

        yield return null;

        var expected = null as DepthSpacePoint[];
        var actual = comp.DepthCoordinates;

        Assert.AreNotEqual(expected, actual, "DepthCoordinates should not be null value when kinect disconnected.");
    }

    [UnityTest]
    public IEnumerator DepthCoordinates_Not_Equal_Null_When_Kinect_Connected()
    {
        var comp = ActiveComponent();

        yield return null;

        var expected = null as DepthSpacePoint[];
        var actual = comp.DepthCoordinates;

        Assert.AreNotEqual(expected, actual, "DepthCoordinates should not be null value when kinect connected.");
    }

    [UnityTest]
    public IEnumerator BodyBuffer_Not_Null_Equal_When_Kinect_Disconnected()
    {
        var comp = InactiveComponent();

        yield return null;

        var expected = null as KinectModule.IBody[];
        var actual = comp.BodyBuffer;

        Assert.AreNotEqual(expected, actual, "BodyBuffer should not be null value when kinect disconnected.");
    }

    [UnityTest]
    public IEnumerator BodyBuffer_Not_Null_Equal_When_Kinect_Connected()
    {
        var comp = ActiveComponent();

        yield return null;

        var expected = null as KinectModule.IBody[];
        var actual = comp.BodyBuffer;

        Assert.AreNotEqual(expected, actual, "BodyBuffer should not be null value when kinect connected.");
    }

    CoordinateMapperManager ActiveComponent()
    {
        var tmpObj = new GameObject();

        return tmpObj.AddComponent<CoordinateMapperManager>();
    }

    CoordinateMapperManager InactiveComponent()
    {
        var tmpObj = new GameObject();
        var comp = tmpObj.AddComponent<CoordinateMapperManager>();
        tmpObj.SetActive(false);

        return comp;
    }
}