﻿using System;

namespace MotionAnalysis
{
    [Flags]
    public enum MotionState : uint
    {
        UNKNOWN              = 0x00000,
        CLAP_PREPARE         = 0x00001,
        CLAP_DONE            = 0x00002,
        JUMP_PREPARE         = 0x00004,
        JUMP_DONE            = 0x00008,
        HURRAY               = 0x00010,
        HAND_MOVE_UP_LEFT    = 0x00020,
        HAND_MOVE_DOWN_LEFT  = 0x00040,
        HAND_MOVE_UP_RIGHT   = 0x00080,
        HAND_MOVE_DOWN_RIGHT = 0x00100,
        GUARD_BASE_LEFT      = 0x00200,
        GUARD_BASE_RIGHT     = 0x00400,
        HAND_UP_LEFT         = 0x00800,
        HAND_DOWN_LEFT       = 0x01000,
        HAND_UP_RIGHT        = 0x02000,
        HAND_DOWN_RIGHT      = 0x04000,
        JESUS                = 0x10000,
        HEADPHONE_LEFT       = 0x20000,
        HEADPHONE_RIGHT      = 0x40000,
        ON_THE_TABLE         = 0x80000,
        ALL                  = 0xFFFFF
    }
}