using System;
using System.Collections;
using UnityEngine;

public class PushUp : MotionNote
{
    private static Sprite image;
    public override Sprite Image
    {
        get
        {
            return image;
        }
    }

    public PushUp(string key, float start, float end = 0f) : this(start, end)
    {
        switch (key)
        {
            case "BP":
                image = LoadNewSprite("Assets/MotionNotes/BP.png");
                MotionName = "PushUpBoth";
                break;
            case "LP":
                image = LoadNewSprite("Assets/MotionNotes/LP.png");
                MotionName = "PushUpLeft";
                break;
            case "RP":
                image = LoadNewSprite("Assets/MotionNotes/RP.png");
                MotionName = "PushUpRight";
                break;
            case "BK":
                image = LoadNewSprite("Assets/MotionNotes/BK.png");
                MotionName = "JumpPushUpBoth";
                break;
            case "LK":
                image = LoadNewSprite("Assets/MotionNotes/LK.png");
                MotionName = "JumpPushUpLeft";
                break;
            case "RK":
                image = LoadNewSprite("Assets/MotionNotes/RK.png");
                MotionName = "JumpPushUpRight";
                break;
        }
    }
    public PushUp(float start, float end = 0f) : base(start, end)
    {
    }
}
