﻿using System;
using System.Collections;
using UnityEngine;

public class Headphone : MotionNote
{
    private static Sprite image;
    public override Sprite Image
    {
        get
        {
            return image;
        }
    }

    public Headphone(string key, float start, float end = 0f) : this(start, end)
    {
        switch (key)
        {
            case "BH":
                image = LoadNewSprite("Assets/MotionNotes/BH.png");
                MotionName = "HeadphoneBoth";
                break;
            case "LH":
                image = LoadNewSprite("Assets/MotionNotes/LH.png");
                MotionName = "HeadphoneLeft";
                break;
            case "RH":
                image = LoadNewSprite("Assets/MotionNotes/RH.png");
                MotionName = "HeadphoneRight";
                break;
        }
    }
    public Headphone(float start, float end = 0f) : base(start, end)
    { }
}
