﻿using System;
using System.Collections.Generic;
using System.IO;
using UnityEngine;

public class TrackInfo
{
    public string Title { get; private set; }
    public string Artist { get; private set; }
    public string Genre { get; private set; }
    public float BPM { get; private set; }
    public int Level { get; private set; }

    public TrackInfo(string path) : this(new FileInfo(path)) { }
    public TrackInfo(FileInfo file)
    {
        ParseBPE(file);
    }

    private void ParseBPE(FileInfo file)
    {
        using (StreamReader reader
            = new StreamReader(new BufferedStream(file.OpenRead())))
        {
            string line;
            while ((line = reader.ReadLine()) != null)
            {
                if (line == "" || line[0] != '#')
                    continue;

                string[] token = line.Split(new char[] { ' ' }, 2);
                string field = token[0];
                string value = token[1].Trim();

                switch (field)
                {
                    case "#TITLE":
                        Title = value;
                        break;
                    case "#ARTIST":
                        Artist = value;
                        break;
                    case "#GENRE":
                        Genre = value;
                        break;
                    case "#BPM":
                        float outBPM;
                        if (float.TryParse(value, out outBPM))
                            BPM = outBPM;
                        else
                            BPM = 0;
                        break;
                    case "#PLAYLEVEL":
                        int outLevel;
                        if (int.TryParse(value, out outLevel))
                            Level = outLevel;
                        else
                            Level = 0;
                        break;
                    default:
                        ParseNote(field, value);
                        break;
                }
            }
        }
    }

    private void ParseNote(string field, string value)
    {
        if (field.Length != 7)
            return;

        string[] CHANNELS = { "SBT", "LBT", "SMN", "LMN" };

        int measure;
        string channel = field.Substring(4, 3);

        if (!int.TryParse(field.Substring(1, 3), out measure))
            return;
        if (Array.FindIndex(CHANNELS, x => x == value) == -1)
            return;


    }
}