﻿using System;
using System.Collections;
using UnityEngine;

public class HandDown : MotionNote
{
    private static Sprite image;
    public override Sprite Image
    {
        get
        {
            return image;
        }
    }

    public HandDown(string key, float start, float end = 0f) : this(start, end)
    {
        switch (key)
        {
            case "BD":
                image = LoadNewSprite("Assets/MotionNotes/BD.png");
                MotionName = "HandDownBoth";
                break;
            case "LD":
                image = LoadNewSprite("Assets/MotionNotes/LD.png");
                MotionName = "HandDownLeft";
                break;
            case "RD":
                image = LoadNewSprite("Assets/MotionNotes/RD.png");
                MotionName = "HandDownRight";
                break;
        }
    }
    public HandDown(float start, float end = 0f) : base(start, end)
    {
    }
}
