using System;
using System.Collections;
using UnityEngine;

public class Guard : MotionNote
{
    private static Sprite image;
    public override Sprite Image
    {
        get
        {
            return image;
        }
    }

    public Guard(string key, float start, float end = 0f) : this(start, end)
    {
        switch (key)
        {
            case "BG":
                image = LoadNewSprite("Assets/MotionNotes/BG.png");
                MotionName = "GuardBoth";
                break;
            case "LG":
                image = LoadNewSprite("Assets/MotionNotes/LG.png");
                MotionName = "GuardLeft";
                break;
            case "RG":
                image = LoadNewSprite("Assets/MotionNotes/RG.png");
                MotionName = "GuardRight";
                break;
        }
    }
    public Guard(float start, float end = 0f) : base(start, end)
    {
    }
}
