﻿using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using UnityEngine;
using UnityEngine.EventSystems;
using UnityEngine.UI;

public class TrackManager : MonoBehaviour {
    [SerializeField]
    GameObject trackList;

    [SerializeField]
    GameObject trackItemPrefab;

    private GameObject selectedTrackItem = null;

    // Use this for initialization
    void Start()
    {
        LoadTracks();
    }
	
    // Update is called once per frame
    void Update()
    {
        if (Input.GetKeyDown(KeyCode.UpArrow))
            trackList.transform.GetChild(0).SetAsLastSibling();
        if (Input.GetKeyDown(KeyCode.DownArrow))
            trackList.transform.GetChild(trackList.transform.childCount - 1).SetAsFirstSibling();
    }
    
    void LoadTracks()
    {
        var files = new DirectoryInfo("Assets/Tracks")
            .GetFiles("*.bpe", SearchOption.AllDirectories);

        TrackInfo[] tracks = files.Select(s => new TrackInfo(s)).ToArray();

        foreach (TrackInfo track in tracks)
        {
            var trackItem = Instantiate(trackItemPrefab, trackList.transform);
//            trackItem.transform.SetParent(trackList.transform);

            trackItem.AddComponent<TrackInfoHolder>().trackInfo = track;

            trackItem.GetComponent<Button>().onClick
                .AddListener(SelectTrackItem);
        }
    }
    
    void SelectTrackItem()
    {
        var caller = EventSystem.current.currentSelectedGameObject;

        // TODO: deactivate selected button

        selectedTrackItem = caller;
    }

    public void StartTrack()
    {
        // TODO: disable start button if nothing selected

        var holder = selectedTrackItem.GetComponent<TrackInfoHolder>();

        GameManager.Instance.CurrentTrack = holder.trackInfo;

        GameManager.Instance.SceneTransition("InGame");
    }
}