﻿using CustomStructure;
using System.Collections.Generic;
using System.Linq;

namespace TrackAnalysis
{
    public class TrackHeader
    {
        public string Title { get; private set; }
        public string Artist { get; private set; }
        public string Genre { get; private set; }
        public float BPM { get; private set; }
        public int Level { get; private set; }
        public string BGM { get; private set; }
        public List<string> TrackList { get; private set; }

        public
            void
            ExtractHeader(
                MultiDictionary<string, string> parseResult)
        {
            Title = ExtractMetaString(
                            parseResult,
                            "#TITLE");
            Artist = ExtractMetaString(
                            parseResult,
                            "#ARTIST");
            Genre = ExtractMetaString(
                            parseResult,
                            "#GENRE");
            BPM = ExtractBPM(
                            parseResult);
            Level = ExtractLevel(
                            parseResult);
            TrackList = ExtractMetaList(
                            parseResult,
                            "#TRACKLIST");
            BGM = ExtractMetaString(
                            parseResult,
                            "#WAV");
        }

        private
            List<string>
            ExtractMetaList(
                MultiDictionary<string, string> parseResult,
                string key)
        {
            List<string> list;

            if (parseResult.TryGetValue(key, out list))
            {
                parseResult.Remove(key);
                return list;
            }

            return Enumerable.Empty<string>().ToList();
        }

        private
            string
            ExtractMetaString(
                MultiDictionary<string, string> parseResult,
                string key)
        {
            List<string> list = ExtractMetaList(parseResult, key);

            return list.Count() == 0 ? null : list[0];
        }

        private
            float
            ExtractBPM(
                MultiDictionary<string, string> parseResult)
        {
            string str = ExtractMetaString(parseResult, "#BPM");

            float outBPM;
            if (float.TryParse(str, out outBPM))
                return outBPM;
            else
                return 0;
        }

        private
            int
            ExtractLevel(
                MultiDictionary<string, string> parseResult)
        {
            string str = ExtractMetaString(parseResult, "#PLAYLEVEL");

            int outLevel;
            if (int.TryParse(str, out outLevel))
                return outLevel;
            else
                return 0;
        }
    }
}