﻿using System;
using System.Reflection;

namespace TrackAnalysis
{
    public class MotionNoteMaker : NoteMakerBase
    {
        override protected
            bool
            NotValidType(
                string type,
                string code)
        {
            return type.Substring(1) != "MO" ||
                !MotionNote.keymap.ContainsKey(code);
        }

        override protected
            Note
            MakeShort(
                string code,
                string type,
                float timing)
        {
            return (Note)Activator.CreateInstance
                (MotionNote.keymap[code], code, type, timing, 0);
        }

        override protected
            Note
            MakeLong(
                string code,
                string type,
                float timing)
        {
            float start = Timing.Value;
            Timing = null;

            return (Note)Activator.CreateInstance
                (MotionNote.keymap[code], code, type, start, timing);
        }
    }
}
