﻿using System;
using System.Collections;
using UnityEngine;

public class OnTheTable : MotionNote
{
    private static Sprite image = LoadNewSprite("Assets/MotionNotes/JP.png");
    public override Sprite Image
    {
        get
        {
            return image;
        }
    }

    public OnTheTable(string key, float timing) : this(timing)
    {
    }
    public OnTheTable(float timing) : base(timing)
    {
    }

    public override void Checkpoint()
    {
        IsChecked = true;
    }

    public override bool FinalJudgeAction()
    {
        return (InputManager.Instance.CurrentMotionState
            & MotionState.ON_THE_TABLE) != 0;
    }
}
