using System;
using System.Collections;
using UnityEngine;

public class Jump : MotionNote
{
    private static Sprite image = LoadNewSprite("Assets/MotionNotes/JP.png");
    public override Sprite Image
    {
        get
        {
            return image;
        }
    }

    public Jump(string key, float timing) : this(timing)
    {
    }
    public Jump(float timing) : base(timing)
    {
    }

    public override void Checkpoint()
    {
        IsChecked = (InputManager.Instance.CurrentMotionState
            & MotionState.JUMP_PREPARE) != 0;
    }

    public override bool FinalJudgeAction()
    {
        return (InputManager.Instance.CurrentMotionState
            & MotionState.JUMP_DONE) != 0;
    }
}
