﻿using System;
using System.Collections;
using UnityEngine;

public class Headphone : MotionNote
{
    enum Hand { Both, Left, Right }
    Hand hand;

    MotionState done;

    private static Sprite image;
    public override Sprite Image
    {
        get
        {
            return image;
        }
    }

    public Headphone(string key, float timing) : this(timing)
    {
        switch (key)
        {
            case "BH":
                hand = Hand.Both;
                image = LoadNewSprite("BH");
                done =  MotionState.HEADPHONE_LEFT | MotionState.HEADPHONE_RIGHT;
                break;
            case "LH":
                hand = Hand.Left;
                image = LoadNewSprite("LH");
                done =  MotionState.HEADPHONE_LEFT;
                break;
            case "RH":
                hand = Hand.Right;
                image = LoadNewSprite("RH");
                done = MotionState.HEADPHONE_RIGHT;
                break;
        }
    }
    public Headphone(float timing) : base(timing)
    {
    }

     public override void Checkpoint()
    {
        IsChecked = true;
    }

    public override bool FinalJudgeAction()
    {
        return (InputManager.Instance.CurrentMotionState
            & done) != 0;
    }
}
