﻿using System;
using System.Collections;
using UnityEngine;

public class HandDown : MotionNote
{
    enum Hand { Both, Left, Right }
    Hand hand;

    MotionState done;

    private static Sprite image;
    public override Sprite Image
    {
        get
        {
            return image;
        }
    }

    public HandDown(string key, float timing) : this(timing)
    {
        switch (key)
        {
            case "BD":
                hand = Hand.Both;
                image = LoadNewSprite("BD");
                done =  MotionState.HAND_DOWN_LEFT | MotionState.HAND_DOWN_RIGHT;
                break;
            case "LD":
                hand = Hand.Left;
                image = LoadNewSprite("LD");
                done =  MotionState.HAND_DOWN_LEFT;
                break;
            case "RD":
                hand = Hand.Right;
                image = LoadNewSprite("RD");
                done = MotionState.HAND_DOWN_RIGHT;
                break;
        }
    }
    public HandDown(float timing) : base(timing)
    {
    }

     public override void Checkpoint()
    {
        IsChecked = true;
    }

    public override bool FinalJudgeAction()
    {
        return (InputManager.Instance.CurrentMotionState
            & done) != 0;
    }
}
