using System;
using System.Collections;
using UnityEngine;

public class Guard : MotionNote
{
    enum Hand { Both, Left, Right }
    Hand hand;

    MotionState prepare, done;

    private static Sprite image;
    public override Sprite Image
    {
        get
        {
            return image;
        }
    }

    public Guard(string key, float timing) : this(timing)
    {
        switch (key)
        {
            case "BG":
                hand = Hand.Both;
                image = LoadNewSprite("BG");
                prepare = MotionState.GUARD_BASE_LEFT | MotionState.GUARD_BASE_RIGHT
                | MotionState.HAND_MOVE_DOWN_LEFT | MotionState.HAND_MOVE_DOWN_RIGHT;
                done =  MotionState.GUARD_BASE_LEFT | MotionState.GUARD_BASE_RIGHT
                | MotionState.HAND_MOVE_UP_LEFT | MotionState.HAND_MOVE_UP_RIGHT;
                break;
            case "LG":
                hand = Hand.Left;
                image = LoadNewSprite("LG");
                prepare = MotionState.GUARD_BASE_LEFT
                | MotionState.HAND_MOVE_DOWN_LEFT;
                done =  MotionState.GUARD_BASE_LEFT
                | MotionState.HAND_MOVE_UP_LEFT;
                break;
            case "RG":
                hand = Hand.Right;
                image = LoadNewSprite("RG");
                prepare = MotionState.GUARD_BASE_RIGHT
                | MotionState.HAND_MOVE_DOWN_RIGHT;
                done = MotionState.GUARD_BASE_RIGHT
                | MotionState.HAND_MOVE_UP_RIGHT;
                break;
        }
    }
    public Guard(float timing) : base(timing)
    {
    }

     public override void Checkpoint()
    {
        IsChecked = (InputManager.Instance.CurrentMotionState
            & prepare) != 0;
    }

    public override bool FinalJudgeAction()
    {
        return (InputManager.Instance.CurrentMotionState
            & done) != 0;
    }
}
