using System;
using System.Collections;
using UnityEngine;

public class Clap : MotionNote
{
    private static Sprite image = LoadNewSprite("Assets/MotionNotes/CP.png");
    public override Sprite Image
    {
        get
        {
            return image;
        }
    }

    public Clap(string key, float timing) : base(timing)
    {
    }
    public Clap(float timing) : base(timing)
    {
    }

    public override void Checkpoint()
    {
        IsChecked = (InputManager.Instance.CurrentMotionState
            & MotionState.CLAP_PREPARE) != 0;
    }

    public override bool FinalJudgeAction()
    {
        return (InputManager.Instance.CurrentMotionState
            & MotionState.CLAP_DONE) != 0;
    }
}
