﻿using System;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

namespace JudgeModule
{
    public class NoteJudger
    {
        private Transform deactives;
        private Action EndGame;
        private GameObject judgeText;

        public NoteJudger(Dictionary<string, GameObject> obj, Action endgame)
        {
            deactives = obj["deactives"].transform;
            judgeText = obj["judgetext"];
            EndGame = endgame;
        }

        public void WrongNoteProc(Note note)
        {
            SetJudge(Judge.MISS, judgeText);
            note.Component.Deactivate(deactives.transform);

            if (!(note is MotionNote))
                EndGame();
        }

        public void EnteredNoteProc(Note note, float timing)
        {
            var judge = Judge.TestJudge(note, timing);

            SetJudge(judge, judgeText);

            if (note.IsLong && !judge.IsBreak)
                note.Activated = true;
            else
                note.Component.Deactivate(deactives.transform);
        }

        public void ContinuingNoteProc(Note note, float timing, float interval)
        {
            if (Judge.IsNoteProgress(note, timing, interval))
            {
                SetJudge(Judge.Perfect, judgeText);
                ++note.JudgeCount;
            }
        }

        public void CorrectlyStoppedNoteProc(Note note, float timing)
        {
            SetJudge(Judge.TestJudge(note, timing, true), judgeText);
            note.Component.Deactivate(deactives.transform);
        }

        public void IncorrectlyStoppedNoteProc(Note note)
        {
            SetJudge(Judge.MISS, judgeText);
            note.Component.Deactivate(deactives.transform);
        }

        public static void SetJudge(Judge judge, GameObject judgeText)
        {
            AllSceneManager.Combo = judge.IsBreak ? 0 : AllSceneManager.Combo + 1;
            AllSceneManager.Score += judge.Score;
            AllSceneManager.JudgeCount[judge]++;

            judgeText.SetActive(false);
            judgeText.SetActive(true);
            judgeText.GetComponent<Text>().text = judge.Name;
            judgeText.GetComponent<Text>().color = judge.Color;

            Debug.Log("SetJudge: " + AllSceneManager.TotalJudge);
        }
    }
}