﻿using StatusConvert;
using System.Collections.Generic;

namespace JudgeModule
{
    public class NoteCondition
    {
        private InputManager manager;
        public NoteCondition(InputManager inputManager)
        {
            manager = inputManager;
        }

        private Dictionary<string, InputStatus> WrongInput(Note note)
        {
            if (note is MotionNote)
                return new Dictionary<string, InputStatus>
                {
                    { "short", manager.ShortButtonStat },
                    { "long",  manager.LongButtonStat  }
                };
            return new Dictionary<string, InputStatus>
            {
                { "short", manager.ShortMotionStat },
                { "long",  manager.LongMotionStat  }
            };
        }

        private  Dictionary<string, InputStatus> JudgeInput(Note note)
        {
            if (note is MotionNote)
                return new Dictionary<string, InputStatus>
                {
                    { "short", manager.MotionToInput((note as MotionNote).MotionName, "short") },
                    { "long",  manager.MotionToInput((note as MotionNote).MotionName, "long")  }
                };
            return new Dictionary<string, InputStatus>
            {
                { "short", manager.ShortButtonStat },
                { "long",  manager.LongButtonStat  }
            };
        }

        public bool IsShortNoteEntered(Note note)
        {
            return JudgeInput(note)["short"] == InputStatus.Entered;
        }

        public bool IsLongNoteStartCorrectly(Note note)
        {
            var stat = JudgeInput(note);
            return (
                        stat["long"] == InputStatus.Entered ||
                        stat["long"] == InputStatus.Continuing
                   ) &&
                   !note.Activated;
        }

        public bool IsLongNoteHoldCorrectly(Note note)
        {
            var stat = JudgeInput(note);
            return (
                        stat["long"] == InputStatus.Entered ||
                        stat["long"] == InputStatus.Continuing
                   ) &&
                   note.Activated;
        }

        public bool IsLongNoteFinishCorrectly(Note note, float timing)
        {
            return JudgeInput(note)["long"] == InputStatus.Stopped &&
                   note.Activated &&
                   Judge.IsNoteEnd(note, timing);
        }

        public bool IsLongNoteFinishIncorrectly(Note note, float timing)
        {
            return JudgeInput(note)["long"] == InputStatus.Stopped &&
                   (
                        !note.Activated ||
                        !Judge.IsNoteEnd(note, timing)
                   );
        }

        public bool IsWrongInput(Note note)
        {
            var stat = WrongInput(note);
            return stat["short"] == InputStatus.Entered ||
                   stat["long"] == InputStatus.Entered ||
                   stat["long"] == InputStatus.Continuing;
        }
    }
}