﻿using UnityEngine;
using UnityEngine.TestTools;
using NUnit.Framework;
using System.Collections;

class CoordinateMapperViewTests
{
    // TODO: Reduce warning factors
    [UnityTest]
    public IEnumerator MainTexture_Equal_Texture_Generate_By_Shader_When_After_Update()
    {
        yield return null;

        GameManager.Instance.SceneTransition("InGame");

        yield return null;

        var tmpObj = GameObject.CreatePrimitive(PrimitiveType.Plane);
        tmpObj.GetComponent<Renderer>().material = Resources.Load("GreenScreen/GreenScreen.mat", typeof(Material)) as Material;

        var material = tmpObj.GetComponent<Renderer>().material;
        SetTextureBuffer(material);

        var CoordinateMapperView = GameObject.Find("CoordinateMapView");

        yield return null;

        var expected = new Texture();
        Graphics.CopyTexture(material.mainTexture, expected);
        Object.Destroy(tmpObj);

        var actual = CoordinateMapperView.GetComponent<Renderer>().material.mainTexture;

        Assert.AreEqual(expected, actual, "texture of gameobject should be same as texture which made by shader.");
    }

    void SetTextureBuffer(Material material)
    {
        var CoordinateMapperManager = GameObject.Find("Managers").GetComponent<CoordinateMapperManager>();
        material.SetTexture("_MainTex", CoordinateMapperManager.ColorTexture);

        var DepthPoints = CoordinateMapperManager.DepthCoordinates;
        var DepthBuffer = new ComputeBuffer(DepthPoints.Length, sizeof(float) * 2);
        material.SetBuffer("depthCoordinates", DepthBuffer);

        var BodyIndexPoints = CoordinateMapperManager.BodyIndexBuffer;
        var BodyIndexBuffer = new ComputeBuffer(BodyIndexPoints.Length, sizeof(float));
        material.SetBuffer("bodyIndexBuffer", BodyIndexBuffer);
    }
}
