﻿using UnityEngine;
using UnityEngine.TestTools;
using NUnit.Framework;
using System.Collections;
using Windows.Kinect;
using System.Runtime.InteropServices;
using System;

// TODO: Change IMGUI to uGUI
public class CoordinateMapperManagerTests
{    
	// A UnityTest behaves like a coroutine in PlayMode
	// and allows you to yield null to skip a frame in EditMode
	[UnityTest]
	public IEnumerator EmptyTest() {
        // Use the Assert class to test conditions.
        // yield to skip a frame
        yield return null;
	}

    [UnityTest]
    public IEnumerator NullFrame_GUI_Show_When_Kinect_Disconnected()
    {
        yield return null;
    }

    [UnityTest]
    public IEnumerator FPS_GUI_Show_When_Kinect_Disconnected()
    {
        yield return null;
    }

    [UnityTest]
    public IEnumerator FPS_GUI_Show_When_Kinect_Connected()
    {
        yield return null;
    }

    [UnityTest]
    public IEnumerator ColorTexture_Not_Equal_Null_When_Kinect_Disconnected()
    {
        var comp = InactiveComponent();

        yield return null;

        var expected = null as Texture2D;
        var actual = comp.ColorTexture;

        Assert.AreNotEqual(expected, actual, "ColorTexture should not be null value when kinect disconnected.");
    }

    [UnityTest]
    public IEnumerator ColorTexture_Not_Equal_Null_When_Kinect_Connected()
    {
        var comp = ActiveComponent();

        yield return null;

        var expected = null as Texture2D;
        var actual = comp.ColorTexture;

        Assert.AreNotEqual(expected, actual, "ColorTexture should not be null value when kinect connected.");
    }

    [UnityTest]
    public IEnumerator BodyIndexBuffer_Not_Equal_Null_When_Kinect_Disconnected()
    {
        var comp = InactiveComponent();

        yield return null;

        var expected = null as byte[];
        var actual = comp.BodyIndexBuffer;

        Assert.AreNotEqual(expected, actual, "BodyIndexBuffer should not be null value when kinect disconnected.");
    }

    [UnityTest]
    public IEnumerator BodyIndexBuffer_Not_Equal_Null_When_Kinect_Connected()
    {
        var comp = ActiveComponent();

        yield return null;

        var expected = null as byte[];
        var actual = comp.BodyIndexBuffer;

        Assert.AreNotEqual(expected, actual, "BodyIndexBuffer should not be null value when kinect connected.");
    }

    [UnityTest]
    public IEnumerator DepthCoordinates_Not_Equal_Null_When_Kinect_Disconnected()
    {
        var comp = InactiveComponent();

        yield return null;

        var expected = null as DepthSpacePoint[];
        var actual = comp.DepthCoordinates;

        Assert.AreNotEqual(expected, actual, "DepthCoordinates should not be null value when kinect disconnected.");
    }

    [UnityTest]
    public IEnumerator DepthCoordinates_Not_Equal_Null_When_Kinect_Connected()
    {
        var comp = ActiveComponent();

        yield return null;

        var expected = null as DepthSpacePoint[];
        var actual = comp.DepthCoordinates;

        Assert.AreNotEqual(expected, actual, "DepthCoordinates should not be null value when kinect connected.");
    }

    [UnityTest]
    public IEnumerator BodyBuffer_Not_Null_Equal_When_Kinect_Disconnected()
    {
        var comp = InactiveComponent();

        yield return null;

        var expected = null as KinectModule.IBody[];
        var actual = comp.BodyBuffer;

        Assert.AreNotEqual(expected, actual, "BodyBuffer should not be null value when kinect disconnected.");
    }

    [UnityTest]
    public IEnumerator BodyBuffer_Not_Null_Equal_When_Kinect_Connected()
    {
        var comp = ActiveComponent();

        yield return null;

        var expected = null as KinectModule.IBody[];
        var actual = comp.BodyBuffer;

        Assert.AreNotEqual(expected, actual, "BodyBuffer should not be null value when kinect connected.");
    }

    CoordinateMapperManager ActiveComponent()
    {
        var tmpObj = new GameObject();

        return tmpObj.AddComponent<CoordinateMapperManager>();
    }

    CoordinateMapperManager InactiveComponent()
    {
        var tmpObj = new GameObject();
        var comp = tmpObj.GetComponent<CoordinateMapperManager>();
        tmpObj.SetActive(false);

        return comp;
    }
}
