using System;
using System.Collections;
using UnityEngine;

public class PushUp : MotionNote
{
    enum Hand { Both, Left, Right }
    Hand hand;

    MotionState prepare, done;

    private static Sprite image;
    public override Sprite Image
    {
        get
        {
            return image;
        }
    }

    public PushUp(string key, float start, float end = 0f) : this(start, end)
    {
        switch (key)
        {
            case "BP":
                hand = Hand.Both;
                image = LoadNewSprite("BP");
                prepare = MotionState.HAND_MOVE_UP_LEFT | MotionState.HAND_MOVE_UP_RIGHT;
                done = MotionState.HAND_MOVE_DOWN_LEFT | MotionState.HAND_MOVE_DOWN_RIGHT;
                break;
            case "LP":
                hand = Hand.Left;
                image = LoadNewSprite("LP");
                prepare = MotionState.HAND_MOVE_UP_LEFT;
                done = MotionState.HAND_MOVE_DOWN_LEFT;
                break;
            case "RP":
                hand = Hand.Right;
                image = LoadNewSprite("RP");
                prepare = MotionState.HAND_MOVE_UP_RIGHT;
                done = MotionState.HAND_MOVE_DOWN_RIGHT;
                break;
        }
    }
    public PushUp(float start, float end = 0f) : base(start, end)
    {
    }

     public override void Checkpoint()
    {
        IsChecked = (InputManager.Instance.CurrentMotionState
            & prepare) != 0;
    }

    public override bool FinalJudgeAction()
    {
        return (InputManager.Instance.CurrentMotionState
            & done) != 0;
    }
}
