using System;
using System.Collections;
using UnityEngine;

public class Jump : MotionNote
{
    private static Sprite image = LoadNewSprite("Assets/MotionNotes/JP.png");
    public override Sprite Image
    {
        get
        {
            return image;
        }
    }

    public Jump(string key, float start, float end = 0f) : this(start, end)
    {
    }
    public Jump(float start, float end = 0f) : base(start, end)
    {
    }

    public override void Checkpoint()
    {
        IsChecked = (InputManager.Instance.CurrentMotionState
            & MotionState.JUMP_PREPARE) != 0;
    }

    public override bool FinalJudgeAction()
    {
        return (InputManager.Instance.CurrentMotionState
            & MotionState.JUMP_DONE) != 0;
    }
}
