﻿using System;
using System.Collections;
using UnityEngine;

public class HandUp : MotionNote
{
    enum Hand { Both, Left, Right }
    Hand hand;

    MotionState done;

    private static Sprite image;
    public override Sprite Image
    {
        get
        {
            return image;
        }
    }

    public HandUp(string key, float start, float end = 0f) : this(start, end)
    {
        switch (key)
        {
            case "BU":
                hand = Hand.Both;
                image = LoadNewSprite("BU");
                done =  MotionState.HAND_UP_LEFT | MotionState.HAND_UP_RIGHT;
                break;
            case "LU":
                hand = Hand.Left;
                image = LoadNewSprite("LU");
                done =  MotionState.HAND_UP_LEFT;
                break;
            case "RU":
                hand = Hand.Right;
                image = LoadNewSprite("RU");
                done = MotionState.HAND_UP_RIGHT;
                break;
        }
    }
    public HandUp(float start, float end = 0f) : base(start, end)
    {
    }

     public override void Checkpoint()
    {
        IsChecked = true;
    }

    public override bool FinalJudgeAction()
    {
        return (InputManager.Instance.CurrentMotionState
            & done) != 0;
    }
}
