using System;
using System.Collections;
using UnityEngine;

public class Clap : MotionNote
{
    private static Sprite image = LoadNewSprite("Assets/MotionNotes/CP.png");
    public override Sprite Image
    {
        get
        {
            return image;
        }
    }

    public Clap(string key, float start, float end = 0f) : this(start, end)
    {
    }
    public Clap(float start, float end = 0f) : base(start, end)
    {
    }

    public override void Checkpoint()
    {
        IsChecked = (InputManager.Instance.CurrentMotionState
            & MotionState.CLAP_PREPARE) != 0;
    }

    public override bool FinalJudgeAction()
    {
        return (InputManager.Instance.CurrentMotionState
            & MotionState.CLAP_DONE) != 0;
    }
}
