﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System.IO;
using UnityEngine.UI;


public class InputManager : MonoBehaviour {
    private static InputManager instance;
    KinectScript ks;
    bool isUpdating = false;
    public Text txt;

    public static InputManager Instance
    {
        get
        {
            if (instance == null)
            {
                instance = FindObjectOfType(typeof(InputManager))
                    as InputManager;
            }

            return instance;
        }
    }

    private bool IsButtonDown { get; set; }
    
    public Pair<float, MotionState> CurrentMotionState { get; set; }

    public bool IsButtonPressed
    {
        get
        {
            return !IsButtonDown && Input.anyKey;
        }
    }

    public bool IsButtonReleased
    {
        get
        {
            return IsButtonDown && !Input.anyKey;
        }
    }

    public bool IsButtonHolding
    {
        get
        {
            return IsButtonDown && Input.anyKey;
        }
    }

    // Use this for initialization
    void Start()
    {
        ks = GameObject.Find("Managers").GetComponent<KinectScript>();
    }

    // Update is called once per frame
    void Update()
    {
        IsButtonDown = Input.anyKey;

        if(!isUpdating)
        {
            isUpdating = true;
            ks.StartUpdating();
        }
        
        CurrentMotionState = ks.GetState();

        if(CurrentMotionState!=null)
        Debug.Log(CurrentMotionState.second.ToString());

        GameObject.Find("Wall").GetComponent<Renderer>().material.mainTexture = ks.GetImage();
    }
}