﻿using MotionAnalysis;
using NUnit.Framework;
using System.Collections.Generic;
using Windows.Kinect;

public class DistItvExtractorTests
{
    [Test]
    public void DistHandBaseSpineShoulder_Should_Null_When_Constructed()
    {
        var obj = new DistItvExtractor(0.0f);

        var expected = true;
        var actual = (obj.DistHandBaseSpineShoulder == null);

        Assert.AreEqual(expected, actual, "DistHandBaseSpineShoulder should be null value when constructed");
    }

    [Test]
    public void DistHandBaseSpineShoulder_Should_Not_Null_When_Update_Valid_Body()
    {
        var obj = new DistItvExtractor(0.0f);
        obj.Extract(new ClapBasicBodyStub());

        var expected = false;
        var actual = (obj.DistHandBaseSpineShoulder == null);

        Assert.AreEqual(expected, actual, "DistHandBaseSpineShoulder should not be null value when update with valid body");
    }
}

public class ClapBasicBodyStub : BodyFake
{
    public ClapBasicBodyStub()
    {
        Joints = new Dictionary<JointType, KinectModule.IJoint>
        {
            { JointType.HandLeft,      new JointStub() },
            { JointType.HandRight,     new JointStub() },
            { JointType.SpineShoulder, new JointStub() }
        };
    }
}