﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public enum NoteType { SBT, LBT, SMO, LMO, BeatLine, MeasureLine }

public class Note
{
    public class Controller : MonoBehaviour
    {
        public Note Instance { get; set; }

        private float time = 0f;

        private readonly float minAlpha = 0.3f;
        private readonly float maxAlpha = 0.7f;

        // Use this for initialization
        void Start()
        {
            Instance.Component = this;
        }

        // Update is called once per frame
        void Update()
        {
            if (Instance.Activated)
            {
                time += Time.deltaTime * 3;

                foreach (Image img in GetComponentsInChildren<Image>())
                {
                    Color tmp = img.color;
                    tmp.a = 0f;
                    img.color = tmp + new Color(0, 0, 0,
                        (maxAlpha + minAlpha) / 2
                        + Mathf.Cos(time * 4) * (maxAlpha - minAlpha) / 2);
                }
            }
        }

        public void Deactivate()
        {
            foreach (Image img in GetComponentsInChildren<Image>())
            {
                Color tmp = img.color;
                tmp.a = 0f;
                img.color = tmp + new Color(0, 0, 0, minAlpha);
            }
        }
    }

    public Controller Component { get; private set; }

    public float StartTiming { get; private set; }
    public float EndTiming { get; private set; }
    public NoteType Type { get; private set; }
    public string Key { get; private set; }

    public bool Activated { get; set; }

    public bool IsLong
    {
        get
        {
            return Length != 0f;
        }
    }

    public float Length
    {
        get
        {
            return EndTiming - StartTiming;
        }
    }

    public Note(float start, float end)
    {
        StartTiming = start;

        if (end == 0f)
            EndTiming = start;
        else
            EndTiming = end;
    }

    public Note(NoteType type, float start, float end = 0f)
    : this(start, end)
    {
        Type = type;
    }

    public Note(string type, float start, float end = 0f)
    : this(start, end)
    {
        switch (type)
        {
            case "SBT":
                Type = NoteType.SBT;
                break;
            case "LBT":
                Type = NoteType.LBT;
                break;
            case "SMO":
                Type = NoteType.SMO;
                break;
            case "LMO":
                Type = NoteType.LMO;
                break;
            default:
                break;
        }
    }

    public Note(string key, string type, float start, float end = 0f)
    : this(type, start, end)
    {
        Key = key;
    }
}
