﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class MotionSampleDisplay : MonoBehaviour
{
    [SerializeField]
    GameObject left, right;

    public Sprite sprite;
    public float timeout;
    public MotionNote caller;

    private float elapsedTime;
    private float velocity;
    private float acceleration;

    private float distance = 3f;

    // Use this for initialization
    void Start()
    {
        elapsedTime = 0f;
        velocity = 0f;
        acceleration = 2 * distance / Mathf.Pow(timeout, 2);

        left.GetComponent<SpriteRenderer>().sprite = sprite;
        right.GetComponent<SpriteRenderer>().sprite = sprite;

        left.transform.Translate(-distance, -0.8f, 0);
        left.transform.localScale = new Vector3(0.5f, 0.5f);
        right.transform.Translate(distance, -0.8f, 0);
        right.transform.localScale = new Vector3(0.5f, 0.5f);
    }

    // Update is called once per frame
    void Update()
    {
        float delta = Time.deltaTime * 1000f;
        elapsedTime += delta;
        velocity = acceleration * elapsedTime;

        if (elapsedTime > timeout)
        {
            Destroy(gameObject);
        }

        left.transform.Translate(new Vector3(velocity * delta, 0));
        right.transform.Translate(new Vector3(-velocity * delta, 0));
    }
}