﻿using System.Collections;
using System.Collections.Generic;
using System.Linq;

namespace CustomStructure
{
    public class MultiDictionary<TKey, TValue> : IEnumerable<KeyValuePair<TKey, List<TValue>>>
    {
        private Dictionary<TKey, List<TValue>> dictionary = new Dictionary<TKey, List<TValue>>();

        public List<TValue> this[TKey key]
        {
            get
            {
                List<TValue> list;
                if (!dictionary.TryGetValue(key, out list))
                {
                    list = new List<TValue>();
                    dictionary[key] = list;
                }

                return list;
            }
            set
            {
                List<TValue> list;
                if (!dictionary.TryGetValue(key, out list))
                    dictionary[key] = value;
                else
                    dictionary[key] = list.Concat(value).ToList();
            }
        }

        public
            bool
            TryGetValue(
                TKey key,
                out List<TValue> value)
        {
            return dictionary.TryGetValue(key, out value);
        }

        public
            IEnumerator<KeyValuePair<TKey, List<TValue>>>
            GetEnumerator()
        {
            return dictionary.GetEnumerator();
        }

        IEnumerator
        IEnumerable.GetEnumerator()
        {
            return GetEnumerator();
        }

        public
            bool
            Remove(
                TKey key)
        {
            return dictionary.Remove(key);
        }

        public List<TKey> Keys
        {
            get
            {
                return dictionary.Keys.ToList();
            }
        }

        public List<List<TValue>> Values
        {
            get
            {
                return dictionary.Values.ToList();
            }
        }
    }
}