﻿using UnityEngine.TestTools;
using System.Collections;
using UnityEngine;
using StatusConvert;
using NUnit.Framework;
using MotionAnalysis;

class InputManagerTests
{
    [UnityTest]
    public IEnumerator ShortButtonStat_Should_None_State_When_Release_After_Release()
    {
        var obj = new GameObject();
        var input = obj.AddComponent<InputManager>();

        yield return null;

        input.IsButtonDown = false;

        yield return null;

        input.IsButtonDown = false;

        var expected = InputStatus.None;
        var actual = input.ShortButtonStat;

        Assert.AreEqual(expected, actual, "ShortButtonStat should be none state when button was released after released");
    }

    [UnityTest]
    public IEnumerator ShortButtonStat_Should_Entered_State_When_Press_After_Release()
    {
        var obj = new GameObject();
        var input = obj.AddComponent<InputManager>();

        yield return null;

        input.IsButtonDown = false;

        yield return null;

        input.IsButtonDown = true;

        var expected = InputStatus.Entered;
        var actual = input.ShortButtonStat;

        Assert.AreEqual(expected, actual, "ShortButtonStat should be entered state when button was pressed after released");
    }

    [UnityTest]
    public IEnumerator LongButtonStat_Should_None_State_When_Release_After_Release()
    {
        var obj = new GameObject();
        var input = obj.AddComponent<InputManager>();

        yield return null;

        input.IsButtonDown = false;

        yield return null;

        input.IsButtonDown = false;

        var expected = InputStatus.None;
        var actual = input.LongButtonStat;

        Assert.AreEqual(expected, actual, "LongButtonStat should be none state when button was released after released");
    }

    [UnityTest]
    public IEnumerator LongButtonStat_Should_Entered_State_When_Press_After_Release()
    {
        var obj = new GameObject();
        var input = obj.AddComponent<InputManager>();

        yield return null;

        input.IsButtonDown = false;

        yield return null;

        input.IsButtonDown = true;

        var expected = InputStatus.Entered;
        var actual = input.LongButtonStat;

        Assert.AreEqual(expected, actual, "LongButtonStat should be entered state when button was pressed after released");
    }

    [UnityTest]
    public IEnumerator LongButtonStat_Should_Stoped_State_When_Release_After_Press()
    {
        var obj = new GameObject();
        var input = obj.AddComponent<InputManager>();

        yield return null;

        input.IsButtonDown = true;

        yield return null;

        input.IsButtonDown = false;

        var expected = InputStatus.Stopped;
        var actual = input.LongButtonStat;

        Assert.AreEqual(expected, actual, "LongButtonStat should be stoped state when button was released after pressed");
    }

    [UnityTest]
    public IEnumerator LongButtonStat_Should_Continuing_State_When_Press_After_Press()
    {
        var obj = new GameObject();
        var input = obj.AddComponent<InputManager>();

        yield return null;

        input.IsButtonDown = true;

        yield return null;

        input.IsButtonDown = true;

        var expected = InputStatus.Continuing;
        var actual = input.LongButtonStat;

        Assert.AreEqual(expected, actual, "LongButtonStat should be continuing state when button was pressed after pressed");
    }

    [UnityTest]
    public IEnumerator ShortMotionStat_Should_None_State_When_None_After_None()
    {
        var obj = new GameObject();
        var input = obj.AddComponent<InputManager>();

        yield return null;

        input.CurrentMotionState = MotionState.UNKNOWN;

        yield return null;

        input.CurrentMotionState = MotionState.UNKNOWN;

        var expected = InputStatus.None;
        var actual = input.ShortMotionStat;

        Assert.AreEqual(expected, actual, "ShortMotionStat should be none state when motion was none after none by clap");
    }

    [UnityTest]
    public IEnumerator ShortMotionStat_Should_Entered_State_When_Done_After_Prepared_By_Clap()
    {
        var obj = new GameObject();
        var input = obj.AddComponent<InputManager>();

        yield return null;

        input.CurrentMotionState = MotionState.CLAP_PREPARE;

        yield return null;

        input.CurrentMotionState = MotionState.CLAP_DONE;

        var expected = InputStatus.Entered;
        var actual = input.ShortMotionStat;

        Assert.AreEqual(expected, actual, "ShortMotionStat should be entered state when motion was done after prepared by clap");
    }

    [UnityTest]
    public IEnumerator LongMotionStat_Should_None_State_When_None_After_None_By_Jesus()
    {
        var obj = new GameObject();
        var input = obj.AddComponent<InputManager>();

        yield return null;

        input.CurrentMotionState = MotionState.UNKNOWN;

        yield return null;

        input.CurrentMotionState = MotionState.UNKNOWN;

        var expected = InputStatus.None;
        var actual = input.LongMotionStat;

        Assert.AreEqual(expected, actual, "LongMotionStat should be none state when motion was none after none by jesus");
    }

    [UnityTest]
    public IEnumerator LongMotionStat_Should_Entered_State_When_Prepared_After_None_By_Jesus()
    {
        var obj = new GameObject();
        var input = obj.AddComponent<InputManager>();

        yield return null;

        input.CurrentMotionState = MotionState.UNKNOWN;

        yield return null;

        input.CurrentMotionState = MotionState.JESUS;

        var expected = InputStatus.Entered;
        var actual = input.LongMotionStat;

        Assert.AreEqual(expected, actual, "LongMotionStat should be entered state when motion was prepared after none by jesus");
    }

    [UnityTest]
    public IEnumerator LongMotionStat_Should_None_State_When_None_After_Done_By_Jesus()
    {
        var obj = new GameObject();
        var input = obj.AddComponent<InputManager>();

        yield return null;

        input.CurrentMotionState = MotionState.JESUS;

        yield return null;

        input.CurrentMotionState = MotionState.UNKNOWN;

        var expected = InputStatus.None;
        var actual = input.LongMotionStat;

        Assert.AreEqual(expected, actual, "LongMotionStat should be none state when motion was none after done by jesus");
    }

    [UnityTest]
    public IEnumerator LongMotionStat_Should_Entered_State_When_Prepared_After_Prepared_By_Jesus()
    {
        var obj = new GameObject();
        var input = obj.AddComponent<InputManager>();

        yield return null;

        input.CurrentMotionState = MotionState.JESUS;

        yield return null;

        input.CurrentMotionState = MotionState.JESUS;

        var expected = InputStatus.Entered;
        var actual = input.LongMotionStat;

        Assert.AreEqual(expected, actual, "LongMotionStat should be entered state when motion was prepared after prepared by jesus");
    }

    [UnityTest]
    public IEnumerator LongMotionStat_Should_Entered_State_When_Done_After_Done_By_Jesus()
    {
        var obj = new GameObject();
        var input = obj.AddComponent<InputManager>();

        yield return null;

        input.CurrentMotionState = MotionState.JESUS;

        yield return null;

        input.CurrentMotionState = MotionState.JESUS;

        var expected = InputStatus.Entered;
        var actual = input.LongMotionStat;

        Assert.AreEqual(expected, actual, "LongMotionStat should be entered state when motion was done after done by jesus");
    }

    [UnityTest]
    public IEnumerator Jesus_Should_None_State_When_None_After_None()
    {
        var obj = new GameObject();
        var input = obj.AddComponent<InputManager>();

        yield return null;

        input.CurrentMotionState = MotionState.UNKNOWN;

        yield return null;

        input.CurrentMotionState = MotionState.UNKNOWN;

        var expected = InputStatus.None;
        var actual = input.MotionToInput("Jesus", "long");

        Assert.AreEqual(expected, actual, "Jesus should be none state when motion was none after none");
    }

    [UnityTest]
    public IEnumerator Jesus_Should_Entered_State_When_Prepared_After_None()
    {
        var obj = new GameObject();
        var input = obj.AddComponent<InputManager>();

        yield return null;

        input.CurrentMotionState = MotionState.UNKNOWN;

        yield return null;

        input.CurrentMotionState = MotionState.JESUS;

        var expected = InputStatus.Entered;
        var actual = input.MotionToInput("Jesus", "long");

        Assert.AreEqual(expected, actual, "Jesus should be entered state when motion was prepared after none");
    }

    [UnityTest]
    public IEnumerator Jesus_Should_Stopped_State_When_None_After_Done()
    {
        var obj = new GameObject();
        var input = obj.AddComponent<InputManager>();

        yield return null;

        input.CurrentMotionState = MotionState.JESUS;

        yield return null;

        input.CurrentMotionState = MotionState.UNKNOWN;

        var expected = InputStatus.Stopped;
        var actual = input.MotionToInput("Jesus", "long");

        Assert.AreEqual(expected, actual, "Jesus should be stopped state when motion was none after done");
    }

    [UnityTest]
    public IEnumerator Jesus_Should_Continuing_State_When_Prepared_After_Prepared()
    {
        var obj = new GameObject();
        var input = obj.AddComponent<InputManager>();

        yield return null;

        input.CurrentMotionState = MotionState.JESUS;

        yield return null;

        input.CurrentMotionState = MotionState.JESUS;

        var expected = InputStatus.Continuing;
        var actual = input.MotionToInput("Jesus", "long");

        Assert.AreEqual(expected, actual, "Jesus should be continuing state when motion was prepared after prepared");
    }

    [UnityTest]
    public IEnumerator Jesus_Should_Continuing_State_When_Done_After_Done()
    {
        var obj = new GameObject();
        var input = obj.AddComponent<InputManager>();

        yield return null;

        input.CurrentMotionState = MotionState.JESUS;

        yield return null;

        input.CurrentMotionState = MotionState.JESUS;

        var expected = InputStatus.Continuing;
        var actual = input.MotionToInput("Jesus", "long");

        Assert.AreEqual(expected, actual, "Jesus should be continuing state when motion was done after done");
    }
}
