﻿using UnityEngine;
using UnityEngine.UI;

namespace JudgeModule
{
    class MotionGageManager
    {
        public GameObject motionGuage;
        private float elapsedMotion;
        private float motionTimeout;
        private float elapsedTime = 0;

        public void ResetGuage(float timeout = 0f)
        {
            if (timeout <= 0f)
            {
                elapsedMotion = 0f;
                motionGuage.transform.parent.gameObject.SetActive(false);
                return;
            }

            motionTimeout = timeout;
            motionGuage.transform.parent.gameObject.SetActive(true);
            motionGuage.SetActive(true);
        }
        public void UpdateGuage()
        {
            if (motionGuage.transform.parent.gameObject.activeInHierarchy)
                UpdateTime();

            if (elapsedMotion >= motionTimeout)
                ResetGuage();
            else
                motionGuage.GetComponent<Image>().fillAmount = elapsedMotion / motionTimeout;
        }

        public float UpdateTime()
        {
            elapsedTime += (Time.deltaTime * 1000);

            return elapsedTime;
        }
    }
}
