﻿using System.Collections.Generic;
using System.Linq;
using UnityEngine;

namespace JudgeModule
{
    public class Judge
    {
        public static readonly List<Judge> JudgeList = new List<Judge>
        {
            new Judge("PERFECT") { ButtonTimingRange = PerfectTime,  Score = 2, Color = Color.cyan },
            new Judge("GOOD")    { ButtonTimingRange = GoodTime,     Score = 1, Color = Color.yellow },
            new Judge("BAD")     { ButtonTimingRange = BadTime,                 Color = Color.blue, IsBreak = true },
            new Judge("MISS")    { Color = Color.red, IsBreak = true }
        };
    
        private Judge()
        {
            ButtonTimingRange = 0f;
            Score = 0;
            IsBreak = false;
            Color = Color.black;
        }
    
        private Judge(string name) : this() { Name = name; }
    
        public string Name { get; private set; }
    
        private const float PerfectTime = 80f,
                            GoodTime    = 100f,
                            BadTime     = 120f;
    
        public float ButtonTimingRange { get; private set; }
        public int   Score { get; private set; }
        public bool  IsBreak { get; private set; }
        public Color Color { get; private set; }
    
        public static readonly Judge BAD = JudgeList[2];
        public static readonly Judge MISS = JudgeList.Last();
        public static readonly
            float MaxButtonTimingRange = BadTime;
    
        public static Judge TestJudge(Note note, float elapsedTime, bool end = false, bool test = false)
        {
            float timing = end ? note.EndTiming : note.StartTiming;
            float difference = elapsedTime - timing;
    
            if (test)
                Debug.Log(difference);
    
            var result = JudgeList.Where(x => Mathf.Abs(difference) < x.ButtonTimingRange).ToList();
    
            return result.Count == 0 ? JudgeList.Last() : result[0];
        }
    
        public static bool IsPastNote(Note note, float elapsedTime)
        {
            float timing = note.IsLong && note.Activated ? note.EndTiming : note.StartTiming;
            return elapsedTime - timing > BadTime;
        }
    
        public static bool IsNoteStart(Note note, float elapsedTime)
        {
            return note is MotionNote &&
                   !note.Activated;
        }
    
        public static bool IsNoteEnd(Note note, float elapsedTime)
        {
            return elapsedTime - note.EndTiming <= BadTime;
        }
    
        public static bool IsNoteComboBroken(Judge judge)
        {
            return judge == BAD ||
                   judge == MISS;
        }
    }
}