﻿using CustomStructure;
using System.Collections.Generic;
using System.Linq;

namespace TrackAnalysis
{
    public class TrackNotes
    {
        public IEnumerable<Note> Notes
        { get; private set; }

        public
            void
            ExtractNotes(
                MultiDictionary<string, string> parseResult,
                float interval)
        {
            var validSigns = ExtractValidSigns(parseResult);
            CreateNotes(validSigns, interval);
            CreateBeatLines(ExtractEnd(validSigns), interval);
        }

        private
            IEnumerable<KeyValuePair<string, List<string>>>
            ExtractValidSigns(
                MultiDictionary<string, string> parseResult)
        {
            return parseResult.Where(x => IsValidSignType(x.Key));
        }

        private
            bool
            IsValidSignType(
                string signType)
        {
            int measure;

            return signType.Length == 7 &&
                   int.TryParse(signType.Substring(1, 3), out measure) &&
                   Enumerable.Contains(new List<string> { "SBT", "LBT", "SMO", "LMO" },
                                       signType.Substring(4, 3));
        }

        private
            int
            ExtractEnd(
                IEnumerable<KeyValuePair<string, List<string>>> validSigns)
        {
            return validSigns.Select(x => int.Parse(x.Key.Substring(1, 3))).Max();
        }

        private
            void
            CreateBeatLines(
                int end,
                float interval)
        {
            Notes = Notes.Concat(Enumerable.Range(1, (end + 1) * 4)
                                           .Select(x => new Note(NoteType.BeatLine, (x / 4.0f) * interval)))
                                           .ToList();
        }

        private
            void
            CreateNotes(
                IEnumerable<KeyValuePair<string, List<string>>> validSigns,
                float interval)
        {
            Notes = Enumerable.Empty<Note>();
            var noteMaker = new NoteMaker();

            validSigns.ToList().ForEach(x => AddNoteSign(x, interval, noteMaker));
        }

        private
            void
            AddNoteSign(
                KeyValuePair<string, List<string>> parsedItem,
                float interval,
                NoteMaker noteMaker)
        {
            parsedItem.Value.ForEach(x => Notes = Notes.Concat(NoteSignGenerator.SignToNotes(x, parsedItem.Key, interval, noteMaker)));
        }
    }
}