﻿using CustomStructure;
using System.Collections.Generic;
using System.IO;
using System.Linq;

namespace TrackAnalysis
{
    public class TrackInfo
    {
        public string Title { get; private set; }
        public string Artist { get; private set; }
        public string Genre { get; private set; }
        public float BPM { get; private set; }
        public int Level { get; private set; }

        public float BeatInterval
        { get { return 4 * 60 * 1000f / BPM; } }

        public string BGM { get; private set; }

        public List<string> TrackList { get; private set; }

        public List<Note> Notes { get; private set; }

        public
            TrackInfo(
                string path)
            : this(
                new FileInfo(
                    path))
        { }

        public
            TrackInfo(
                FileInfo file)
        {
            MultiDictionary<string, string> parseResult = ParseBPE(file);

            ExtractTrackHeader(parseResult);

            TrackNotes notes = new TrackNotes();
            notes.ExtractNotes(parseResult, BeatInterval);
            Notes = notes.Notes.ToList();
        }

        private
            MultiDictionary<string, string>
            ParseBPE(
                FileInfo file)
        {
            MultiDictionary<string, string> result = new MultiDictionary<string, string>();

            using (StreamReader reader
                = new StreamReader(new BufferedStream(file.OpenRead())))
            {
                string line;
                while ((line = reader.ReadLine()) != null)
                {
                    if (line == "" || line[0] != '#')
                        continue;

                    string[] token = line.Split(new char[] { ' ' }, 2);

                    result[token[0]] = new List<string> { token[1].Trim() };
                }
            }

            return result;
        }

        private
            void
            ExtractTrackHeader(
                MultiDictionary<string, string> parseResult)
        {
            TrackHeader header = new TrackHeader();
            header.ExtractHeader(parseResult);

            Title = header.Title;
            Artist = header.Artist;
            Genre = header.Genre;
            BPM = header.BPM;
            Level = header.Level;
            TrackList = header.TrackList;
            BGM = header.BGM;
        }
    }
}
