﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace TrackAnalysis
{
    public class NoteSignGenerator
    {
        public static
            IEnumerable<Note>
            SignToNotes(
                string sign,
                string signType,
                float interval,
                NoteMaker noteMaker)
        {
            return GenerateNoteSequence(Enumerable.Range(0, sign.Length / 2),
                             x => CurrentCode(x, sign),
                             x => ComputeTiming(int.Parse(signType.Substring(1, 3)), x, sign.Length / 2, interval),
                             (code, timing) => MakeNote(noteMaker, code, signType.Substring(4, 3), timing));
        }

        private static
            string
            CurrentCode(
                int location,
                string sign)
        {
            return sign.Substring(location * 2, 2);
        }

        private static
            float
            ComputeTiming(
                float measure,
                int location,
                int sequenceSize,
                float interval)
        {
            return (measure + (float)location / sequenceSize) * interval;
        }

        private static
            Note
            MakeNote(
                NoteMaker noteMaker,
                string code,
                string type,
                float timing)
        {
            return noteMaker.Make(code, type, timing);
        }

        private static
            IEnumerable<Note>
            GenerateNoteSequence(
                IEnumerable<int> range,
                Func<int, string> currentCode,
                Func<int, float> calcTiming,
                Func<string, float, Note> concreteNote)
        {
            return DiscreteRange(range, x => currentCode(x))
            .Select(x => concreteNote(currentCode(x), calcTiming(x)))
            .Where(x => x != null);
        }

        private static
            IEnumerable<int>
            DiscreteRange(
                IEnumerable<int> range,
                Func<int, string> currentCode)
        {
            return range.Where(x => currentCode(x).Equals("00"));
        }
    }
}