﻿namespace TrackAnalysis
{
    public abstract class NoteMakerBase
    {
        protected float? Timing = null;

        public
            Note
            Make(
                string code,
                string type,
                float timing)
        {
            if (NotValidType(type))
                return null;
            if (IsShort(type))
                return MakeShort(code, type, timing);
            if (IsLongEnd(type))
                return MakeLong(code, type, timing);

            RegisterTiming(timing);

            return null;
        }

        private
            bool
            IsShort(
                string type)
        {
            return type[0] == 'S';
        }

        private
            bool
            IsLongEnd(
                string type)
        {
            return type[0] == 'L' && Timing != null;
        }

        private
            void
            RegisterTiming(
                float timing)
        {
            Timing = timing;
        }

        abstract protected
            bool
            NotValidType(
                string type);
        abstract protected
            Note
            MakeShort(
                string code,
                string type,
                float timing);
        abstract protected
            Note
            MakeLong(
                string code,
                string type,
                float timing);
    }
}